(defclass display-obj ()
  ((truck-obj :accessor truck-obj   :initarg :truck-obj)
   (truck-area :accessor truck-area :type truck-disp)
   (map-area :accessor map-area     :type map-disp)
   (loc-area :accessor loc-area     :type loc-disp)
   (current-location-obj :accessor current-location-obj :initform nil)))

;************************************************************

(defmethod current-location? ((self display-obj) obj)
  (or (eq obj 'current-location)
      (eq obj (current-location-obj self))
      (and (current-location-obj self)
           (eq obj (unique-id (current-location-obj self))))))

(defmethod dm-add ((self display-obj) bay-name obj)
  (cond ((current-location?  self bay-name)
         (if (not (eq obj (truck-obj self)))
           (dm-add (loc-area self) '() obj)))
        (else (dm-add (truck-area self) bay-name obj))))

(Defmethod dm-del ((self display-obj) bay-name obj)
  (if (current-location? self bay-name)
	  (dm-del (loc-area self) '() obj)
	  (dm-del (truck-area self) bay-name obj)))

(defmethod dm-empty ((self display-obj) bay-name)
  (if (current-location? self bay-name)
	  (dm-empty (loc-area self) '())
	  (dm-empty (truck-area self) bay-name)))

(defmethod dm-set ((self display-obj) gauge-name val)
  (cond 
	((current-location? self gauge-name)
	 (setf (current-location-obj self) val)
	 (dm-set (loc-area self) '() val)
	 (dm-set (map-area self) '() val))
	(t (dm-set (truck-area self) gauge-name val))))

(defmethod dm-move ((self display-obj) arm-name new-loc)
  (t-cond 
   ((current-location? self new-loc)
	(dm-move (truck-area self) arm-name 'current-location))
   ((or (memq new-loc '(folded tire-bay  weapon-bay fuel-bay fuel-gauge inside))
		(memq new-loc (bay-names (truck-area self))))
	(dm-move (truck-area self) arm-name new-loc))
   ((or (dm-locate-obj (truck-area self) new-loc)
		(dm-locate-obj (loc-area self) new-loc))
     	=>
	#'(lambda (pos-list)
		(dm-move (truck-area self) arm-name pos-list)))
   (t (cerror "To continue" "Don't know how to move to this location."))))

(defmethod dm-mnes ((self display-obj) arm-name bay-or-loc-name)
  (cond ((memq bay-or-loc-name '(fuel-gauge fuel-bay))
         (dm-move self arm-name bay-or-loc-name))
        ((current-location? self bay-or-loc-name)
         (dm-move (truck-area self)
				  arm-name
                  (list 'current-location
                        (next-empty-space (loc-area self) '()))))
        (t (dm-mnes (truck-area self) arm-name bay-or-loc-name))))

(defmethod dm-refresh ((self display-obj))
  (dm-refresh (truck-area self))
  (dm-refresh (map-area self))
  (dm-refresh (loc-area self)))

(defmethod dm-redraw ((self display-obj) appendage obj)
  (dm-redraw (truck-area self) appendage obj))

(defmethod dm-speak ((self display-obj) x) 
  (values))

(defmethod dm-close ((self display-obj))
  (disp.terminate))

