#include <stdio.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/param.h>

/*
 * Connect to a socket by service name or port number.
 * If port is 0, service will be used.
 * Returns a file descriptor for the socket.
 */

int
connect_to_socket(hostname, service, proto, port)
char	*hostname;
char	*service;
u_int	port;
int     proto;

{
    struct sockaddr_in	remote_addr;	/* remote inet socket address	*/
    struct servent	*serv;		/* returned by getservbyname()	*/
    struct hostent	*host;		/* returned by gethostbyname()	*/
    int			sock;

    if (strlen(service) <= 0)
	service = NULL;

    if (proto == TCP)		/* make a stream socket */
      { if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) 
	  { perror("stream socket");
	    return (-1);
	  }
      }
    else if (proto == UDP)	/* make a datagram socket */
      { if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) 
	  { perror("dgram socket");
	    return (-1);
	  }
      }


printf("socket fd: %d\n",sock);
fflush(stdout);

    if (service != NULL) {
	if ((serv = getservbyname(service, NULL)) == NULL) {
	    if (port <= 0) {
		fprintf(
		    stderr,
		    "Unknown serv %s/tcp. No default port given\n",
		    service
		);
		return(-1);
	    }
	    remote_addr.sin_port = htons((u_short) port);
	}
	else
	    remote_addr.sin_port = serv->s_port;
    }
    else
	remote_addr.sin_port = htons((u_short) port);


				/*  Now we bind the socket to the right port */
    if (proto == UDP)
      { remote_addr.sin_addr.s_addr = INADDR_ANY;
	if (bind(sock, &remote_addr, sizeof(remote_addr)) < 0)  
	  { perror("bind");
	    return (-1);}
      }

    if ((host = gethostbyname(hostname)) == NULL) {
	perror("gethostbyname");
	return (-1);
    }

    remote_addr.sin_family = host->h_addrtype;
    bcopy(host->h_addr, &remote_addr.sin_addr, host->h_length);

printf("host addr: %d.%d.%d.%d\n", (host->h_addr)[0],
       (host->h_addr)[1],
       (host->h_addr)[2],
       (host->h_addr)[3]);

printf("service port: %d\n",remote_addr.sin_port);
       
    if (connect(sock, &remote_addr, sizeof(remote_addr)) < 0)  
	  { perror("connect");
	    shutdown(sock,2);
	    close(sock);
	    return (-1);}

    return(sock);
}

/* Just open the right service to Flakey */

open_tcp_port(host)
char *host;
{  return(connect_to_socket(host,"trobot",TCP,TROBOT_PORT));
 }

open_udp_port(host)
char *host;
{  return(connect_to_socket(host,"urobot",UDP,UROBOT_PORT));
 }


open_unix_port(host)		/* host is the socket name */
char *host;
{
  int sock;
  struct sockaddr_un server;

  if ((sock = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) 
    { perror("unix socket");
      return (-1);
    }

  server.sun_family = AF_UNIX;	/* connect */
  strcpy(server.sun_path, host);
  if (connect(sock, (struct sockaddr *)&server, sizeof(struct sockaddr_un)) < 0)
    { perror ("Can't bind unix socket to ROBOT"); 
      close(sock);
      return(-1);
    }
  return(sock);
}

close_sock(fd)
int fd;
{ shutdown(fd,2);
  close(fd); }


/*
 * call to open tty channel
 *	Exit:	0 returned if no errors
 */

static struct sgttyb tty_data;
static struct sgttyb old_tty_data;

int
open_tty_port(char *tty)
{	
  int n = 200, i = 0;
  int tty_fd;
  FILE *tty_f;
  /* open an input channel from the tty */
  if ((tty_fd = open(tty,O_RDONLY | O_NDELAY)) < 0)
    {
      fprintf(stdout, "Couldn't open tty for input.\n"); fflush(stdout);
      return(-1);
    }
  ioctl(tty_fd,TIOCGSOFTCAR,&n); /* get soft carrier flag */
  i = 1;
  ioctl(tty_fd,TIOCSSOFTCAR,&i); /* get soft carrier flag */
  ioctl(tty_fd,TIOCGSOFTCAR,&n); /* get soft carrier flag */
	/* open an output channel to the tty */
  if ((tty_fd = open(tty,O_RDWR)) < 0)
    {	
      fprintf(stdout, "Couldn't open tty for output.\n"); fflush(stdout);
      return(-1);
    }
  /* set the tty baud, buffering and modes */
  tty_f = fdopen(tty_fd,"w+");
  setbuf(tty_f, NULL);			/* no stdio buffering */
  
  ioctl (tty_fd, TIOCGETP, &old_tty_data);/* save tty conf */
  ioctl (tty_fd, TIOCGETP, &tty_data);/* get tty conf to change */
  tty_data.sg_flags = RAW;		/* set tty to raw mode */
  tty_data.sg_ispeed = TTY_SPEED;		/* set input baud */
  tty_data.sg_ospeed = TTY_SPEED;		/* set output baud */
  ioctl (tty_fd, TIOCSETP, &tty_data);/* write new tty conf */
  return(tty_fd);
}



int flakey_tcp_fd = -1;		/* file descriptor for tcp socket */

open_tcp_line()
{
  if ((flakey_tcp_fd = open_tcp_port(host)) < 0) /* opened? */
    { 
      printf("\nCouldn't open FLAKEY tcp service"); 
      return(-1);
    }
  else
    {
      input_comm_line(flakey_tcp_fd); /* set up comm streams */
      output_comm_line(flakey_tcp_fd);
      return(0);
    }
}

int flakey_unix_fd = -1;	/* file descriptor for unix socket */

open_unix_line(host)
{
  if ((flakey_unix_fd = open_unix_port(host)) < 0) /* opened? */
    { 
      printf("\nCouldn't open FLAKEY tcp service"); 
      return(-1);
    }
  else
    {
      input_comm_line(flakey_tcp_fd); /* set up comm streams */
      output_comm_line(flakey_tcp_fd);
      return(0);
    }
}

int flakey_tty_fd = -1;		/* file descriptor for tty socket */

open_tty_line(host)		/* host is the /dev tty */
{
  if ((flakey_tty_fd = open_tty_port(host)) < 0) /* opened? */
    { 
      printf("\nCouldn't open FLAKEY tcp service"); 
      return(-1);
    }
  else
    {
      input_comm_line(flakey_tcp_fd); /* set up comm streams */
      output_comm_line(flakey_tcp_fd);
      return(0);
    }
}


shutdown_flakey_line()		/* close current connection */
{
  if (flakey_tcp_fd > 0)
    {
      close_sock(flakey_tcp_fd);
      flakey_tcp_fd = -1;
    }
  if (flakey_unix_fd > 0)
    {
      close(flakey_unix_fd);
      flakey_unix_fd = -1;
    }
  if (flakey_tty_fd > 0)
    {	
      ioctl (flakey_tty_fd, TIOCSETP, &old_tty_data); /* restore conf */
      close(flakey_tty_fd);
      return(0);
    }
}






