/* Some timing functions to be used by LISP
 *
 * Might be more accurate than the stupid LUcid routines
 */


#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

/* ------------------------------------------------------------------------ */

static struct timeval tvb, tve;

int_time(ms)			/* waits for ms millisecs to have passed */
				/* since the last call */

{
  int t1;

  gettimeofday(&tve,NULL);
  t1 = tvsub(&tve,&tvb);
  tvb = tve;
  if (t1 <= 0) { return(0); }
  t1 = ms - t1;
  if (t1 <= 0) { return(0); }
  ms_pause(t1);
  gettimeofday(&tvb,NULL);
  return(t1);
}


tvsub(tv1,tv2)
struct timeval *tv1, *tv2;
{
  return(((tv1->tv_sec - tv2->tv_sec)*1000) + ((tv1->tv_usec - tv2->tv_usec) / 1000));
}


ms_pause (milliseconds)
int milliseconds;
{
    struct timeval delay;
    int readfds, writefds, execfds;
    delay.tv_sec = milliseconds / 1000;
    delay.tv_usec = (milliseconds % 1000) * 1000;
    select (0, &readfds, &writefds, &execfds, &delay);
}
