/*
 * Structure definitions for the Erratic simulator
 */

typedef unsigned char	 byte;		/* define an 8 bit byte */

/* 
 * Use single-format floating point for most values
 * Homogenous coordinates (3-vectors for 2-D world)
 * Angles in radians, distances in mm
 */

/* Segments  */
typedef struct
{
  float x1, y1;			/* normalized endpoints */
  float x2, y2;
  float a, b, c;		/* line parameters */
  float a1, b1, c1;		/* perp line at x1, y1 */
  float a2, b2, c2;		/* perp line at x2, y2 */
  float norm;			/* line normalization, a**2 + b**2 */
  float th;			/* angle of segment, in rads */
} seg;

/* Points */
typedef struct
{
  float x,y,w;			/* normalized using w */
} pt;

/* Lines */
typedef struct
{
  float a, b, c;
} line;


/* Definition of the robot structure. */

typedef struct 
{
  float x,y, th;		/* abs pos in mm and rads */
  float dx, dy, dth;		/* integrated pos in mm and rads */
  float tv, rv;			/* trans vel (mm/sec) and ang vel (rads/sec) */
  float mtv, mrv;		/* user maximums, in same units */
  float ta, ra;			/* instantaneous acc, in mm/sec/sec and rads/sec/sec */
  float mta, mra;		/* user maximums */
  float atv, arv, ata, ara;	/* robot physical maximums */
  int bumpmov;			/* 0 if no contact, +1 if moving forward, -1 if backward */
  float bumper;			/* direction of bumper contact, in rads */

  float rad;			/* radius of robot, in mm */
} simrobot;

extern simrobot erratic;	/* global variable for simulation robot */


/* a simple structure to hold the movement state of the robot */

#define STOPPED 0
#define POS 1
#define VEL 2

typedef struct
{
  int tr_state;			/* translation servo state of robot: stopped, pos, vel */
  float tr_pos, tr_accum;	/* position to achieve, and current accumulation */
  int rot_state;		/* same for rotation */
  float rot_pos, rot_accum;	
} servo_robot;

extern servo_robot errservo;



/* arrays of pointers */


typedef struct
{
  int n;			/* current number of elements in array */
  int max;			/* max array size */
  char **arr;			/* pointer to array of pointers */
} ptrlist;

typedef struct			/* bucket arrays */
{
  int n;
  int max;
  seg *segs[100];
} buclist;

extern buclist *cur_seg_list;	/* current local segments */


/* simulation world definition */

typedef struct
{
  float w, h;			/* height and width, in mm */
  float local;			/* local area in mm */
  int x,y;			/* number of width and height buckets */
  buclist *b;			/* buckets holding local segments of the world */
  ptrlist ss;			/* holds all segments */
} simworld;

extern simworld world;		/* current world */

