/*
 * Parameter definition for a typical robot
 */

#define ATV_MAX 2000.0   	/* Max translational velocity, mm/sec */
#define ARV_MAX 1.5		/* Max rotational velocity, rads/sec */
#define ATA_MAX 500.0		/* Max trans accel, mm/sec/sec */
#define ARA_MAX 1.0		/* Max rot accel, rads/sec/sec (is this too high?) */
#define TRANS_TO_ROT_ACC (1.0/250.0) /* Ration of trans to rot acceleration */

#define ERRATIC_RAD 290.0	/* Radius of robot, in mm */

/* Cycle times */

#define MIN_CYCLE_TIME 100	/* in ms, real time per cycle */
#define SIM_CYCLE_TIME 100	/* in ms, simulation time per cycle */

extern float inc_time;		/* time constant for simulation, in seconds */
extern int last_move;		/* time accumulation since last move command issued */

/* Sonar beam parameters */

#define SONAR_HALF_ANGLE 10.0	/* half-angle of sonar beam */
#define SONAR_BEAM_FAN_SPREAD 4	/* number of rays to use */

#define SONAR_LONG_RANGE 2500.0	/* long distance reflection, mm */
#define SONAR_SHORT_RANGE 300.0 /* short distance reflection, mm */
#define SONAR_OUT_OF_RANGE 3000.0 /* furthest possible reflection */

#define SONAR_GOOD_ANGLE 75.0	/* up to this point is a good reflection */
#define SONAR_BAD_ANGLE 60.0	/* from this point is a bad reflection */
#define SONAR_CLOSE_ANGLE 50.0	/* when we're close, this is a good angle */
