section $-objects => energy, thirst, smell;


/*
Standard objects
----------------
*/


lib pb_objects.p;


/*
Physiology
----------
*/


vars __smelly, __last_eat_time;


define my_start1();
    false -> __smelly;
    0 -> __last_eat_time;
enddefine;


define my_update();
    if __smelly and __last_eat_time < $-eden$-time-5 then
        kill( 'You smell of food and have been eaten by a predator!' );
    endif;
enddefine;


define my_line2() -> items -> format;
    lvars format, items;
    lvars s;
    'Inventory: ~8A   Here: ~8A   Time: ~8A Smelly: ~8A' -> format;
    [% object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __smelly
    %] -> items;
enddefine;


/*
Food
----
*/


vars old_food;
food -> old_food;
define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        old_food(message,id,x,y);
        $-eden$-time -> __last_eat_time;
        true -> __smelly;
    else
        old_food(message,id,x,y);
    endswitchon;
enddefine;
define_object( "food", food, `+` );


/*
Cleaning
--------
*/


define water(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        false -> __smelly;
    else
        nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "water", water, `w` );


endsection;
