/* deduct the mean from all the examples */
# include "Tools.h"

void Zero_mean_short(speech, size)
short  *speech;
int     size;
{
  register short  *ptr_speech, *ptr_end = speech + size;
  register int    sum = 0, mean;

  ptr_speech = speech;
  while(ptr_speech < ptr_end) sum += *ptr_speech++;
  mean = floor(0.5 + (double) sum / (double) size);
  ptr_speech = speech;
  while(ptr_speech < ptr_end) *ptr_speech++ -= mean;
}

void Zero_mean_int(speech, size)
int  *speech;
int     size;
{
  register int  *ptr_speech, *ptr_end = speech + size;
  register int    sum = 0, mean;

  ptr_speech = speech;
  while(ptr_speech < ptr_end) sum += *ptr_speech++;
  mean = floor(0.5 + (double) sum / (double) size);
  ptr_speech = speech;
  while(ptr_speech < ptr_end) *ptr_speech++ -= mean;
}

void Zero_mean_float(float *wave, int size) {
  float sum = 0.0, mean;
  int   i;

  for(i = 0; i < size; i++) sum += wave[i];
  mean = sum / size;
  for(i = 0; i < size; i++) wave[i] -= mean;
}

void Zero_mean_double(speech, size)
double  *speech;
int     size;
{
  register double  *ptr_speech, *ptr_end = speech + size;
  register int    sum = 0, mean;

  ptr_speech = speech;
  while(ptr_speech < ptr_end) sum += *ptr_speech++;
  mean = floor(0.5 + (double) sum / (double) size);
  ptr_speech = speech;
  while(ptr_speech < ptr_end) *ptr_speech++ -= mean;
}
