/*
** write a machine to a file
*/
# include "Tools.h"

#define      N          6     /* No. of ints used to define a machine */

int          Write_machine(Machine_type *p, FILE *fp_machine) {
  int size = (p->sta_op * (p->sta_op - 1) -
	      p->hidden * (p->hidden - 1)) / 2 +
	     (p->length - p->sta_op) * p->sta_op;

  if(fwrite((char*) p, sizeof(int), N, fp_machine) != N) return(FALSE);

  /* write out the outputs */
  if(fwrite((char*) p->node_op, sizeof(p->node_op[0]), p->length,
			  fp_machine) != p->length) return(FALSE);

  /* write out the weights */
  if(fwrite((char*) p->weight[0], sizeof(p->weight[0][0]), size,
			  fp_machine) != size) return(FALSE);

  /* write out the smoothed changes */
  if(fwrite((char*) p->smooth[0], sizeof(p->smooth[0][0]), size,
			  fp_machine) != size) return(FALSE);
  return(TRUE);
}
