# include "Tools.h"
# define BIG16

float Weighted_sum(float *weight, float *output, int size) {
  int 	i;
  float sum = 0.0;

#ifdef NODDY
  for(i = 0; i < size; i++) sum += *weight++ * *output++;
#else
#ifdef BIG16
  int size0x10 = size / 0x10;
  
  for(i = 0; i < size0x10; i++) {
    sum += weight[0x0] * output[0x0] + 
           weight[0x1] * output[0x1] + 
           weight[0x2] * output[0x2] + 
           weight[0x3] * output[0x3] + 
           weight[0x4] * output[0x4] + 
           weight[0x5] * output[0x5] + 
           weight[0x6] * output[0x6] + 
           weight[0x7] * output[0x7] + 
           weight[0x8] * output[0x8] + 
           weight[0x9] * output[0x9] + 
           weight[0xa] * output[0xa] + 
           weight[0xb] * output[0xb] + 
           weight[0xc] * output[0xc] + 
           weight[0xd] * output[0xd] + 
           weight[0xe] * output[0xe] + 
           weight[0xf] * output[0xf];
    weight += 0x10;
    output += 0x10;
  }

  for(i = 0; i < size % 0x10; i++) sum += *weight++ * *output++;
#else
  int size8 = size / 8;

  for(i = 0; i < size8; i++) {
    sum += weight[0x0] * output[0x0] + 
           weight[0x1] * output[0x1] + 
           weight[0x2] * output[0x2] + 
           weight[0x3] * output[0x3] + 
           weight[0x4] * output[0x4] + 
           weight[0x5] * output[0x5] + 
           weight[0x6] * output[0x6] + 
           weight[0x7] * output[0x7];
    weight += 8;
    output += 8;
  }

  for(i = 0; i < size % 8; i++) sum += *weight++ * *output++;
#endif
#endif
  return(sum);
}
