/* ASSUMES ONE WEIGHT PER LINK !!!!!!!!!!!!!!!!!!
*/
# include "Tools.h"

void   Update(p)
Machine_type *p;
{
  int i, j;

  /* update weights for hidden units */
  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->weight[i][j] += p->change[i][j];
      p->change[i][j]  = 0.0;
    }

  /* update weights for state and external output units */
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p->sta_op; j++) {
      p->weight[i][j] += p->change[i][j];
      p->change[i][j]  = 0.0;
    }
}

void   Update_eta(p, eta)
Machine_type *p;
Tools_type eta;
{
  int i, j, p_sta_op = p->sta_op;

  /* update weights for hidden units */
  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->weight[i][j] += eta * p->change[i][j];
      p->change[i][j] = 0.0;
    }

  /* update weights for state and external output units */
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p_sta_op; j++) {
      p->weight[i][j] += eta * p->change[i][j];
      p->change[i][j] = 0.0;
    }
}

void   Update_eta_alpha(p, eta, alpha)
Machine_type *p;
Tools_type eta, alpha;
{
  int i, j, p_sta_op = p->sta_op;

  /* update weights for hidden units */
  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->weight[i][j] += 
	eta * (p->smooth[i][j] = p->change[i][j] + alpha * p->smooth[i][j]);
      p->change[i][j] = 0.0;
    }

  /* update weights for state and external output units */
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p_sta_op; j++) {
      p->weight[i][j] += 
	eta * (p->smooth[i][j] = p->change[i][j] + alpha * p->smooth[i][j]);
      p->change[i][j] = 0.0;
    }
}

void   Update_step(p, gt1, lt1)
Machine_type *p;
Tools_type   gt1, lt1;
{
  int i, j;

  /* update weights for hidden units */
  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->smooth[i][j] *=
      p->weight[i][j] += p->smooth[i][j] = SIGN(p->change[i][j]) *
	      fabs(p->smooth[i][j] *
	     ((SIGN(p->change[i][j]) == SIGN(p->smooth[i][j]) ? gt1 : lt1)));
      p->change[i][j]  = 0.0;
    }

  /* update weights for state and external output units */
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p->sta_op; j++) {
      p->weight[i][j] += p->smooth[i][j] = SIGN(p->change[i][j]) *
	      fabs(p->smooth[i][j] *
	     ((SIGN(p->change[i][j]) == SIGN(p->smooth[i][j]) ? gt1 : lt1)));
      p->change[i][j]  = 0.0;
    }
}

void   Update_step_alpha(p, average, gt1, lt1, alpha)
Machine_type *p;
Tools_type   **average, gt1, lt1, alpha;
{
  int i, j;

  /* update weights for hidden units */
  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->weight[i][j] += SIGN(p->change[i][j]) * (p->smooth[i][j] *=
	       (SIGN(p->change[i][j]) == SIGN(average[i][j]) ? gt1 : lt1));
      average[i][j]   = alpha * average[i][j] + (1 - alpha) * p->change[i][j];
      p->change[i][j] = 0.0;
    }

  /* update weights for state and external output units */
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p->sta_op; j++) {
      p->weight[i][j] += SIGN(p->change[i][j]) * (p->smooth[i][j] *=
	       (SIGN(p->change[i][j]) == SIGN(average[i][j]) ? gt1 : lt1));
      average[i][j]   = alpha * average[i][j] + (1 - alpha) * p->change[i][j];
      p->change[i][j] = 0.0;
    }
}

void   Undo_update_step(p)
Machine_type *p;
{
  int i, j;

  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->weight[i][j] -= (p->smooth[i][j] *= 0.5);
      p->change[i][j]  = 0.0;
    }

  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p->sta_op; j++) {
      p->weight[i][j] -= (p->smooth[i][j] *= 0.5);
      p->change[i][j]  = 0.0;
    }
}

