#ifndef _TOOLS_
#define _TOOLS_
/******************************************************************************

Copyright(C) 1992,1993 Tony Robinson

Permission is granted to use this software for non-commercial, non-military
purposes.  It may be copied and distributed freely, provided that this notice
is copied and distributed with it.  Modified versions may be distributed with
the same permissions and restrictions, provided that clear notice of the
alterations is given.  This software carries NO WARRANTY, expressed or
implied.  The user assumes all risks, known or unknown, direct or indirect,
which involve this software in any way.

Acknowledgement is requested if this software contributes significantly
toward any research publication.

Dr Tony Robinson
Cambridge University Engineering Department
Trumpington Street, Cambridge, CB2 1PZ, England.

email: ajr@eng.cam.ac.uk
voice: +44-223-332754

******************************************************************************/

/* include anything that might be useful */
# include <math.h>
# include <stdio.h>
# include <ctype.h>
# include <string.h>
# include <stdlib.h>

#ifdef sun
# include <alloca.h>
#endif

#ifndef TC
# include <unistd.h>
# include <signal.h>
# include <varargs.h>
# include <sys/types.h>
# include <utmp.h>
# include <sys/stat.h>
#ifndef sgi
# include <sys/timeb.h>
#endif
# include <sys/param.h>
# define B011_NODEID 0
#else
# include <conc.h>
# include <float.h>
# include <stdarg.h>
# include <sys/boot.h>
# include <sys/t-rack.h>
# include <sys/node_mmap.h>
# include <sys/ctrl_proto.h>
#endif

#if defined(sun) && ! defined(__svr4__)
/* where are these defined? */
void	bcopy(char*, char*, int);
void	bzero(char*, int);
int	fread(char*, int, int, FILE*);
int	fwrite(char*, int, int, FILE*);
int	printf();
int	fclose(FILE*);
int	fflush(FILE*);
int	fgetc(FILE*);
int	fprintf();
int	fscanf();
int	fseek(FILE*, long, int);
void	rewind(FILE*);
int	scanf();
int	setlinebuf(FILE*);
int	sscanf();
int	system(char*);
int	vfprintf();
#endif

int getnodeid();

# define ONLINE       "/usr/spool/fifo/Online"
# define FIRST_NODEID 1
# define LAST_NODEID  60

#ifndef MAXPATHLEN
# define MAXPATHLEN	1024
#endif

#ifndef M_PI
# define M_PI 3.14159265358979323846
#endif

#ifndef TWO_PI
# define TWO_PI 6.28318530717958647692
#endif

#ifndef	MIN
# define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef	MAX
# define MAX(a,b) (((a)>(b))?(a):(b))
#endif

# define VERY_BIG   1e+37
# define VERY_SMALL 1e-37
# define SIGN(x) ((x) < 0 ? -1 : 1)
# define SQR(x) ((x) * (x))
# define CUBE(x) ((x) * (x) * (x))
# define POW4(x) ((x) * (x) * (x) * (x))
# define ZERO(b1, n) bzero((char*) (b1), (n) * sizeof(*(b1)))
# define COPY(b1, b2, n) bcopy((char*) (b1), (char*) (b2), (n) * sizeof(*(b1)))

# define RETRY(condition) {\
  int t = 0;\
  while condition {\
    fprintf(stderr, "RETRY: sleep(%d)\n", t);\
    sleep(t);\
    t++;\
  }\
}\

# define RETRY8(condition) {\
  int t = 0;\
  while condition {\
    if(t++ == 8) break;\
    fprintf(stderr, "RETRY8: sleep(%d)\n", t);\
    sleep(t);\
  }\
}\

#ifdef TC
# define  schar  signed   char
# define  sshort signed   short
# define  sint   signed   int
# define  uchar  unsigned char
# define  ushort unsigned short
# define  uint   unsigned int
#else
# define  schar           char
# define  sshort          short
# define  sint            int
# define  uchar  unsigned char
# define  ushort unsigned short
# define  uint   unsigned int
#endif

# define  MAX_SCHAR     127
# define  MAX_UCHAR     255
# define  MAX_NAME_SIZE 256
# define  BIAS          1
# define  LNPROB_FLOAT2INT 24.0

/*
** definitions of logical values
*/
# define FALSE 0
# define TRUE ~FALSE
/*
** each error propagation machine has the following structure
*/
#define TOOLS_TYPE "float"
typedef float  Tools_type;
typedef struct Node_struct
{
  int	sizeof_link;
  float	(*active)(double);
  float	(*slope)(double, double);
  float	(*forward)(float*, float*, int);
  void	(*reverse)(float*, float*, int, double);
} Node_type;
typedef struct Machine_struct
{
  int        ext_ip;
  int        sta_ip;
  int        hidden;
  int        sta_op;
  int        ext_op;
  int        length;
  Tools_type *node_ip; 
  Tools_type *node_op;
  Tools_type *delta;
  Tools_type **weight;
  Tools_type **change;
  Tools_type **smooth;
  Node_type  *hid_node;
  Node_type  *sta_node;
  Node_type  *ext_node;
} Machine_type;

#ifndef NODE_TYPES
  extern Node_type Unassigned_node;
  extern Node_type Linear_node;
  extern Node_type Square_node;
  extern Node_type Cube_node;
  extern Node_type Exp_node;
  extern Node_type Safe_exp_node;
  extern Node_type Sigmoid_node;
  extern Node_type Safe_ssigmoid_node;
  extern Node_type Usigmoid_node;
  extern Node_type Safe_usigmoid_node;
  extern Node_type Fudged_usigmoid_node;
#endif

/*
** and these are the functions in the library
*/
# include "Array.h"
# include "Nonlinear.h"

void         Accumulate();
void         Add2();
char        *Allophone2phone(char*);
char        *Allophone2rmphone(char*);
void         Autocorrelate();
void         Backward();
void         Backward_all();
void         Backward_accumulate();
void		Blink(int);
void		Broadcast(char*, int);
void		Broadcast_argc_argv(int*, char***);
void		Broadcast_word(int*);
void	     Change_machine();
float		Compare(Machine_type*, float*);
float	      	Compare_eta(Machine_type*, float*, double);
int          ChanInBlock();
void         ChanOutBlock();
float        ChanInFloat();
void         ChanOutFloat();
void         Copy_weight_matrix();
void Create_machine(Machine_type*, int, int, int, int, int, int, double);
void Create_machine_no_smooth(Machine_type*, int, int, int, int, int, int, double);
void         Dot_product();
double      *Double_hamming();
void         Forward();
float       *Float_hamming();
void         Free_machine();
float		Gasdev(int);
char		*Hash_add(char*, char*, char*);
char		*Hash_find(char*, char*);
char		*Hash_init(int);
void		Hash_print(char*, FILE*); 
float		H_compare(Machine_type*, float*);
float		H_compare_eta(Machine_type*, float*, double);
void		Init_write_down_link1out();
Tools_type 	*Make_array(int);
float		Matrix_invert(float**, float**, int);
void		Matrix_multiply(float**, float**, float**, int, int, int);
void		Matrix_rseigen(float**, float*, float**, int);
void		Matrix_transpose(float**, float**, int, int);
void		Multiply_add2(float*, float*, int, double);
void		Nap(double);
void		Noise(float*, int, double, double);
double		Normalise(float*, int, int);
void		Panic();
char*		Panic_malloc();
float*		Panic_float_hamming();
void		Panic_fclose(FILE*);
FILE*		Panic_fopen(char*, char*);
FILE*		Panic_fopen_3bits(char*, char*, char*, char*);
void		Panic_fprintf_args(int, char**, FILE*);
void		Panic_fread(char*, int, int, FILE*);
void		Panic_free(char*);
void		Panic_fseek(FILE*, long, int);
void		Panic_fwrite(char*, int, int, FILE*);
void		Panic_hamming_float();
void		Ppush(char *data);
char		*Ppull();
void		Print_machine();
Tools_type	Quantise();
float		Ran1(int);
int		Read_machine();
int		Read_swal_machine(Machine_type*, FILE*);
char**		Read_table(char*, int*);
void		RealFFT(float*, float*, int);
void		Reap_array();
double		Scan_double(int, char**, char*, double);
float		Scan_float(int, char**, char*, float);
int		Scan_flag(int, char**, char*);
int		Scan_int(int, char**, char*, int);
char	       *Scan_string();
Tools_type	Scan_tools_type();
void		Scale_one_vector(float*, float*, int, float);
void		Scale_two_vectors(float*, float*, float*, float*, int, float);
void		Set_heapend();
void		Set_weight_matrix(Machine_type*, Tools_type**, Tools_type);
int		Sizeof_weight_matrix();
FILE*		Std_fopen(char*, char*);
int		String2index(char*, char**, int);
Tools_type	Sum_squares();
void		Swal(char*, char*, int); 
int		Swal_fread(char*, int, int, FILE*);
void		Update_eta();
void		Update_eta_alpha();
Tools_type	Weighted_sum();
void		Zero_weight_matrix();

double		erf(double);
double		ierf(double);
double		lncomb(int, int);

float	     lpredict();
void		ref2area();
void		ref2logarea();
void		ref2truearea();

#endif /* _TOOLS_ */
