# define TIMIT_HEADER_SIZE      1024    /* no of bytes in the header */
# define TIMIT_SAMPLE_RATE      16000.0 /* samples per second */
# define TIMIT_MAX_HZ		(TIMIT_SAMPLE_RATE / 2)
# define TIMIT_NALLOPHONE       61
# define TIMIT_NPHONE           40
# define TIMIT_NAPUPHONE        55
# define TIMIT_LABEL_SIZE       5
# define TIMIT_MAX_NFRAME_PER_ALLOPHONE	256
# define TIMIT_SILENCE_INDEX    0
# define TIMIT_INIT_SILENCE     2560
# define TIMIT_QUIT_SILENCE     2560
# define TIMIT_LABEL_MASK	0x7f
# define TIMIT_BOUNDARY_MASK	Panic("TIMIT_BOUNDARY_MASK used\n")
# define TIMIT_SENT_MASK	0x80
# define TIMIT_BYTES_PER_SAMPLE	2
# define TIMIT_MAX_PHNLINE	128
# define TIMIT_EOW	        (-1)
# define TIMIT_DEFAULT_NINP	23
# define TIMIT_CDROM_PATH	"/db/cd-jam0/timit/train/"
# define TIMIT_LOCAL_PATH	"/home/hope/ajr/timit/train/"

# define MAX_LINE_LENGTH	80
# define TIMIT_DEFAULT_PHNTAB	"/home/dsl1/ajr/lib/allophone.tab"
# define TIMIT_DEFAULT_DUR	"/home/dsl1/ajr/lib/timit_trn.dur"

struct dict_entry {
  float prob;
  char *word;
  int  *phone;
};

struct phnline {
  int  init;
  int  quit;
  char label[TIMIT_LABEL_SIZE];
};

struct timing {
  int start;
  int stop;
  int index;
};

#ifdef THIS_IS_OBSOLETE

static char timit_allophone[TIMIT_NALLOPHONE][TIMIT_LABEL_SIZE] = {
  "h#", "pau", "epi", "eh", "ih", "ao", "ae", "aa", "ah", "uw", "uh", "er",
  "ux", "ay", "oy", "ey", "iy", "aw", "ow", "ax", "axr", "ix", "ax-h", "l", 
  "el", "r", "w", "y", "hh", "hv", "s", "sh", "z", "zh", "ch", "jh", "th",
  "dh", "f", "v", "m", "em", "n", "en", "ng", "eng", "nx", "p", "b", "t", "d",
  "k", "g", "pcl", "bcl", "tcl", "dcl", "kcl", "gcl", "dx", "q"};

static char timit_phone[TIMIT_NPHONE][TIMIT_LABEL_SIZE] = { 
  "sil", "aa", "ae", "aw", "ax", "ay", "b", "ch", "d", "dh", "dx", "eh", "er",
  "ey", "f", "g", "hh", "ix", "iy", "jh", "k", "l", "m", "n", "ng", "ow", "oy",
  "p", "q", "r", "s", "t", "th", "uh", "uw", "v", "w", "y", "z", "zh"};

static char timit_apuphone[TIMIT_NALLOPHONE][TIMIT_LABEL_SIZE] = {
  "h#", "pau", "epi", "eh", "ih", "ao", "ae", "aa", "ah", "uw", "uh", "er",
  "ux", "ay", "oy", "ey", "iy", "aw", "ow", "ax", "axr", "ix", "ax-h", "l", 
  "el", "r", "w", "y", "hh", "hv", "s", "sh", "z", "zh", "ch", "jh", "th",
  "dh", "f", "v", "m", "em", "n", "en", "ng", "eng", "nx", "p", "b", "t", "d",
  "k", "g", "dx", "q"};

#endif



