/* 

Thu 28 Feb 1991: Modified by ajr to take an integer as an argument and keep a
separate flag as to whether the ran1 has been initialised.  Any non-zero and
positive integer will reset with a new seed, a zero or negative integer will
use the existing state.  This is done so that pointers don't have to be
carted about.

Name changed from ran1(int*) and gasdev(int*) to Ran1(int) and Gasdev(int).

Also some style changes.

*/

# include "Tools.h"

#define M1 259200
#define IA1 7141
#define IC1 54773
#define RM1 (1.0/M1)
#define M2 134456
#define IA2 8121
#define IC2 28411
#define RM2 (1.0/M2)
#define M3 243000
#define IA3 4561
#define IC3 51349

float Ran1(int seed) {
  static long ix1,ix2,ix3;
  static float r[98];
  float temp;
  static int iff=0;
  int j;

  if (seed != 0 || iff == 0) {
    iff=1;
    ix1=(IC1 + abs(seed)) % M1;
    ix1=(IA1*ix1+IC1) % M1;
    ix2=ix1 % M2;
    ix1=(IA1*ix1+IC1) % M1;
    ix3=ix1 % M3;
    for (j=1;j<=97;j++) {
      ix1=(IA1*ix1+IC1) % M1;
      ix2=(IA2*ix2+IC2) % M2;
      r[j]=(ix1+ix2*RM2)*RM1;
    }
  }
  ix1=(IA1*ix1+IC1) % M1;
  ix2=(IA2*ix2+IC2) % M2;
  ix3=(IA3*ix3+IC3) % M3;
  j=1 + ((97*ix3)/M3);
  if (j > 97 || j < 1) Panic("RAN1: This cannot happen.");
  temp=r[j];
  r[j]=(ix1+ix2*RM2)*RM1;
  return temp;
}

#undef M1
#undef IA1
#undef IC1
#undef RM1
#undef M2
#undef IA2
#undef IC2
#undef RM2
#undef M3
#undef IA3
#undef IC3

float Gasdev(int seed) {
  static int iset = 0;
  static float gset;
  float fac, r, v1, v2;

  if(seed != 0) (void) Ran1(seed);

  if(iset == 0 || seed != 0) {
    do {
      v1 = 2.0 * Ran1(0) - 1.0;
      v2 = 2.0 * Ran1(0) - 1.0;
      r = v1 * v1 + v2 * v2;
    } while (r >= 1.0);
    fac  = sqrt(-2.0 * log(r) / r);
    gset = v1 * fac;
    iset = 1;
    return(v2 * fac);
  }
  else {
    iset = 0;
    return(gset);
  }
}
