#include "Tools.h"

typedef struct pstack_struct {
  struct pstack_struct *prev;
  char *data;
} pstack_type;

pstack_type *lastpstack = (pstack_type*) NULL;

void Ppush(char *data) {
  pstack_type *pnewpstack = (pstack_type*) Panic_malloc(sizeof(pstack_type));

  pnewpstack->prev = lastpstack;
  pnewpstack->data = data;
  lastpstack = pnewpstack;
}

char *Ppull() {

  if(lastpstack != NULL) {
    char *olddata = lastpstack->data;

    Panic_free((char*) lastpstack);
    lastpstack = lastpstack->prev;
    return(olddata);
  }
  else
    return(NULL);
}
