extern int errno;

#define PANIC_lseek(fd, offset, whence)\
  if(lseek(fd, offset, whence) == -1) {\
    perror("PANIC_lseek");\
    exit(errno);\
  }

#define PANIC_read(fd, buf, nbyte)\
  if(read(fd, buf, nbyte) != nbyte) {\
    perror("PANIC_read");\
    exit(errno);\
  }

#define PANIC_write(fd, buf, nbyte)\
  if(write(fd, buf, nbyte) != nbyte) {\
    perror("PANIC_write");\
    exit(errno);\
  }

#ifdef FREE_RETURNS_INT
#define PANIC_free(s)\
  if(free(s) == 0) {\
    perror("PANIC_free");\
    exit(errno);\
  }
#else
#define PANIC_free(s)\
  free(s)
#endif

#define PANIC_fseek(stream, offset, ptrname)\
  if(fseek(stream, offset, ptrname) == -1) {\
    perror("PANIC_fseek");\
    exit(errno);\
  }

#define PANIC_fread(ptr, size, nitems, stream) {\
  int PANIC_fread_nread = fread(ptr, size, nitems, stream);\
  if(PANIC_fread_nread != nitems) {\
    fprintf(stderr, "PANIC: fread(0x%x, %d, %d, 0x%x) == %d\n", ptr, size,\
	    nitems, stream, PANIC_fread_nread);\
    exit(1);\
  }\
}

#define PANIC_fwrite(ptr, size, nitems, stream) {\
  int PANIC_fwrite_nwrite = fwrite(ptr, size, nitems, stream);\
  if(PANIC_fwrite_nwrite != nitems) {\
    fprintf(stderr, "PANIC: fwrite(0x%x, %d, %d, 0x%x) == %d\n", ptr, size,\
	    nitems, stream, PANIC_fwrite_nwrite);\
    exit(1);\
  }\
}

#define PANIC_fclose(stream)\
  if(fclose(stream) == EOF) {\
    fprintf(stderr, "PANIC: fclose(0x%x) == EOF\n", stream);\
    exit(1);\
  }
