# include "Tools.h"
# define  NODE_TYPES
# define  MAX_SAFE_INPUT 32.0

/**********************
**  Unassigned node  **
**********************/
float Unassigned_activ(double ip) {
  fprintf(stderr, "Unassigned node type in existance\n");
  return(0.0);
}

float Unassigned_slope(double ip, double op) {
  fprintf(stderr, "Unassigned node type in existance\n");
  return(0.0);
}

Node_type Unassigned_node =
 {sizeof(float), Unassigned_activ,Unassigned_slope,Weighted_sum,Multiply_add2};

/******************
**  Linear node  **
******************/ 
float Linear_activ(double ip) {
  return(ip);
}

float Linear_slope(double ip, double op) {
  return(1.0);
}

Node_type Linear_node = 
 {sizeof(float), Linear_activ, Linear_slope, Weighted_sum, Multiply_add2};


/******************
**  Square node  **
******************/
float Square_activ(double ip) {
  return(ip * ip);
}

float Square_slope(double ip, double op) {
  return(2.0 * ip);
}

Node_type Square_node = 
 {sizeof(float), Square_activ, Square_slope, Weighted_sum, Multiply_add2};

/****************
**  Cube node  **
****************/
float Cube_activ(double ip) {
  return(ip * ip * ip);
}

float Cube_slope(double ip, double op) {
  return(3.0 * ip * ip);
}

Node_type Cube_node = 
 {sizeof(float), Cube_activ, Cube_slope, Weighted_sum, Multiply_add2};
 
/***********************
**  Exponential node  **
***********************/
float Exp_activ(double ip) {
  return(exp(ip));
}

float Exp_slope(double ip, double op) {
  return(op);
}

Node_type Exp_node = 
 {sizeof(float), Exp_activ, Exp_slope, Weighted_sum, Multiply_add2};

/****************************
**  Safe exponential node  **
****************************/
float Safe_exp_activ(double ip) {
  if(ip > MAX_SAFE_INPUT) ip = MAX_SAFE_INPUT;
  else if(ip < -MAX_SAFE_INPUT) ip = -MAX_SAFE_INPUT;
  return(exp(ip));
}

Node_type Safe_exp_node = 
 {sizeof(float), Safe_exp_activ, Exp_slope, Weighted_sum, Multiply_add2};

/*******************
**  Sigmoid node  **
*******************/
float Sigmoid_activ(double ip) {
  return(2.0 / (1.0 + exp(-2.0 * ip))- 1.0);
}

float Sigmoid_slope(double ip, double op) {
  return((1.0 + op) * (1.0 - op));
}

Node_type Sigmoid_node = 
 {sizeof(float), Sigmoid_activ, Sigmoid_slope,Weighted_sum,Multiply_add2};


/*************************
**  Safe ssigmoid node  **
*************************/
float Safe_ssigmoid_activ(double ip) {
  ip *= -2.0;
  if(ip > MAX_SAFE_INPUT) ip = MAX_SAFE_INPUT;
  else if(ip < -MAX_SAFE_INPUT) ip = -MAX_SAFE_INPUT;
  return(2.0 / (1.0 + exp(ip)) - 1.0);
}

Node_type Safe_ssigmoid_node =
 {sizeof(float), Safe_ssigmoid_activ, Sigmoid_slope, Weighted_sum, Multiply_add2};

/********************
**  Usigmoid node  **
********************/
float Usigmoid_activ(double ip) {
  return(1.0 / (1.0 + exp(-ip)));
}

float Usigmoid_slope(double ip, double op) {
  return(op * (1.0 - op));
}

Node_type Usigmoid_node =
 {sizeof(float), Usigmoid_activ, Usigmoid_slope,Weighted_sum,Multiply_add2};


/*************************
**  Safe usigmoid node  **
*************************/

float Safe_usigmoid_activ(double ip) {
  if(ip > MAX_SAFE_INPUT) ip = MAX_SAFE_INPUT;
  else if(ip < -MAX_SAFE_INPUT) ip = -MAX_SAFE_INPUT;
  return(1.0 / (1.0 + exp(-ip)));
}

Node_type Safe_usigmoid_node =
 {sizeof(double), Safe_usigmoid_activ, Usigmoid_slope, Weighted_sum, Multiply_add2};

/***************************
**  Fudged usigmoid node  **
***************************/
#ifdef later

# define SLOPE_FUDGE 1e-8
float Fudged_usigmoid_slope(double ip, double op) {
  return(op * (1.0 - op) + SLOPE_FUDGE);
}

#endif

# define SLOPE_FUDGE 1e-8
float Fudged_usigmoid_slope(double ip, double op) {
  return((op + SLOPE_FUDGE) * (1.0 + SLOPE_FUDGE - op));
}
      
Node_type Fudged_usigmoid_node =
 {sizeof(float), Usigmoid_activ, Fudged_usigmoid_slope, Weighted_sum, Multiply_add2};
