/******************************************************************************

Perform the operation write[i] += scale * read[i] for all i

The following code takes 9.3s when NODDY is not defined, and 11.4s when NODDY
is defined, it is assumed that there will be a speed up on the transputers as
well.

main() {
  float a[100], b[100];
  int i;
  
  for(i = 0; i < 100; i++) a[i] = b[i] = M_PI * i;

  for(i = 0; i < 100000; i++) Multiply_add2(a, b, 100, M_PI);
}

******************************************************************************/

# include "Tools.h"
# define BIG16

void Multiply_add2(float *read, float *write, int size, double scale) {
  register float rscale = (float) scale;
  int	   i;

#ifdef NODDY
  for(i = 0; i < size; i++) write[i] += rscale * read[i];
#else
#ifdef BIG16
  int size0x10 = size / 0x10;

  for(i = 0; i < size0x10; i++) {
    write[0x0] += rscale * read[0x0];
    write[0x1] += rscale * read[0x1];
    write[0x2] += rscale * read[0x2];
    write[0x3] += rscale * read[0x3];
    write[0x4] += rscale * read[0x4];
    write[0x5] += rscale * read[0x5];
    write[0x6] += rscale * read[0x6];
    write[0x7] += rscale * read[0x7];
    write[0x8] += rscale * read[0x8];
    write[0x9] += rscale * read[0x9];
    write[0xa] += rscale * read[0xa];
    write[0xb] += rscale * read[0xb];
    write[0xc] += rscale * read[0xc];
    write[0xd] += rscale * read[0xd];
    write[0xe] += rscale * read[0xe];
    write[0xf] += rscale * read[0xf];
    read  += 0x10;
    write += 0x10;
  }

  for(i = 0; i < size % 0x10; i++) write[i] += rscale * read[i];
#else
  int size8 = size / 8;

  for(i = 0; i < size8; i++) {
    write[0x0] += rscale * read[0x0];
    write[0x1] += rscale * read[0x1];
    write[0x2] += rscale * read[0x2];
    write[0x3] += rscale * read[0x3];
    write[0x4] += rscale * read[0x4];
    write[0x5] += rscale * read[0x5];
    write[0x6] += rscale * read[0x6];
    write[0x7] += rscale * read[0x7];
    read  += 8;
    write += 8;
  }

  for(i = 0; i < size % 8; i++) write[i] += rscale * read[i];
#endif
#endif
}

