# include "Tools.h"

# define SMALL (1.0 / (1 << 10))
# define LIMIT (1.0 / (1 << 20))

# ifdef IERF_TEST
static double x = -0.994;
int main() {
#else
double ierf(double x) {
#endif

  double last = 1.0, curr = 0.0;

  while(fabs(last - curr) > LIMIT) {
    double erfap = erf(curr);
    double slope = (erf(curr + SMALL) - erf(curr)) / SMALL;

    last = curr;
    curr += (x - erfap) / slope;

# ifdef IERF_TEST
    printf("%f\t%f\n", curr, erf(curr));
# endif

  }

#ifdef IERF_TEST
  exit(0);
#else
  return(curr);
#endif

}
