# include "Tools.h"

typedef struct hlist_struct {
  char   *key;
  char   *data;
  struct hlist_struct *next;
} hlist_type;

typedef struct hashtab_struct {
  int	     tabsize;
  hlist_type *tab[1];		/* the size 1 will always be ignored */
} hashtab_type;

char* Hash_init(int tabsize) {
  int i;
  hashtab_type *hashtab;

  hashtab = (hashtab_type*) malloc(sizeof(int) + tabsize * sizeof(hlist_type*));

  if(hashtab != NULL) {
    ((hashtab_type*) hashtab)->tabsize = tabsize;
    for(i = 0; i < tabsize; i++) hashtab->tab[i] = (hlist_type*) NULL;
  }

  return((char*) hashtab);
}

# define BITS_PER_BYTE 8
# define HASH_KEY_MAX (BITS_PER_BYTE * (1 - sizeof(uint)))

#ifdef __GNUC__
inline 
#endif
uint hash_key(char *key) {
  uint hashed = 0;
  int i, len = strlen(key);

  if(len > HASH_KEY_MAX) len = HASH_KEY_MAX;
  for(i = 0; i < len; i++) hashed += (hashed << 2) + key[i];
  return(hashed);
}

#define HASH_MALLOC_SIZE 2048
hlist_type *Panic_hash_malloc() {
  static int gobbled = 0;
  static hlist_type *space;

  if(gobbled == 0) {
    space = (hlist_type*) Panic_malloc(HASH_MALLOC_SIZE * sizeof(hlist_type));
    gobbled = HASH_MALLOC_SIZE;
  }

  gobbled--;
  return(space + gobbled);
}

char *Hash_add(char *hashtab, char *key, char *data) {
  int index = hash_key(key) % ((hashtab_type*) hashtab)->tabsize;
  hlist_type **pphlist = &(((hashtab_type*) hashtab)->tab[index]);

  while(*pphlist != (hlist_type*) NULL) {
    if(strcmp(key, (*pphlist)->key) == 0) return((char*) &(*pphlist)->data);
    else pphlist = &((*pphlist)->next);
  }

  *pphlist = Panic_hash_malloc();
  (*pphlist)->key  = key;
  (*pphlist)->data = data;
  (*pphlist)->next = NULL;

  return(key);
}

void Hash_fprint(FILE *stream, char *hashtab) {
  int index;

  for(index = 0; index < ((hashtab_type*) hashtab)->tabsize; index++) {
    hlist_type *phlist =  ((hashtab_type*) hashtab)->tab[index];

    fprintf(stream, "%d\t", index);

    while(phlist != (hlist_type*) NULL) {
      fprintf(stream, "%s ", phlist->key);
      phlist = phlist->next;
    }

    fprintf(stream, "\n");
  }
}

char *Hash_find(char *hashtab, char *key) {
  int index = hash_key(key) % ((hashtab_type*) hashtab)->tabsize;
  hlist_type *phlist = ((hashtab_type*) hashtab)->tab[index];

  while(phlist != (hlist_type*) NULL && strcmp(key, phlist->key) != 0)
    phlist = phlist->next;

  if(phlist == (hlist_type*) NULL) return(NULL);
  else return(phlist->data);
}

#ifdef MISSING
void Hash_test() {
  char *hashtab = hash_init(1);

  hash_add(hashtab, "Susanne", "Kunger");
  hash_add(hashtab, "Tommy", "Kubitsky");
  
  printf("%s\n", hash_find(hashtab, "Tommy"));
  printf("%s\n", hash_find(hashtab, "Susanne"));
}
#endif
