/* set up a hamming window of size double presicion floating point numbers */
# include "Tools.h"

float *Float_hamming(int size) {
  float *window, k;
  int    i;

  k = 2.0 * M_PI / size;
  if((window = (float*) malloc(size * sizeof(*window))) != NULL)
    for(i = 0; i < size; i++)
      window[i] = 0.54 - 0.46 * cos(k * (i + 0.5));
  return(window);
}

double *Double_hamming(int size) {
  double *window, k;
  int    i;

  k = 2.0 * M_PI / size;
  if((window = (double*) malloc(size * sizeof(*window))) != NULL)
    for(i = 0; i < size; i++)
      window[i] = 0.54 - 0.46 * cos(k * (i + 0.5));
  return(window);
}

float *Panic_float_hamming(int size) {
  float *windowf;
  
  if((windowf = Float_hamming(size)) == NULL)
    Panic("Panic_float_hamming(%d) == NULL)", size);
  return(windowf);
}

void Panic_hamming_float(float *wave, int size, float *window) {
  static int   nwindowf = 0, i;
  static float *windowf = NULL;

  if(nwindowf != size) {
    if(nwindowf != 0) Panic_free((char*) windowf);
    if((windowf = Float_hamming(size)) == NULL)
      Panic("Panic_hamming: can't make Hamming array\n");
    nwindowf = size;
  }

  for(i = 0; i < size; i++)
    window[i] = windowf[i] * wave[i];
}
