/*
** do a forward pass for a general network without changing the weights or  
** the accumulated weight changes
*/
# include "Tools.h"

void Forward(Machine_type *p) {
  int i;

  /* calculate outputs for hidden outputs */
  for (i = p->hidden; i < p->sta_op; i++)
    p->node_op[i] = p->hid_node->active(
      p->node_ip[i] = p->hid_node->forward(p->weight[i], p->node_op, i));

  /* calculate outputs for state outputs */
  for (i = p->sta_op; i < p->ext_op; i++)
    p->node_op[i] = p->sta_node->active(
     p->node_ip[i] = p->sta_node->forward(p->weight[i], p->node_op,p->sta_op));
 
  /* calculate outputs for external outputs */
  for (i = p->ext_op; i < p->length; i++)
    p->node_op[i] = p->ext_node->active(
     p->node_ip[i] = p->ext_node->forward(p->weight[i], p->node_op,p->sta_op));
}
