/*
** find the dot product between p->change and p->smooth
*/

# include "Tools.h"

void Dot_product(Machine_type *p, float *dot_product, float *change_smag,
		 float *smooth_smag) {
  int i;

  for(i = p->hidden; i < p->sta_op; i++) {
    *dot_product += Weighted_sum(p->change[i], p->smooth[i], i);
    *change_smag += Weighted_sum(p->change[i], p->change[i], i);
    *smooth_smag += Weighted_sum(p->smooth[i], p->smooth[i], i);
  }

  for(i = p->sta_op; i < p->length; i++) {
    *dot_product += Weighted_sum(p->change[i], p->smooth[i], p->sta_op);
    *change_smag += Weighted_sum(p->change[i], p->change[i], p->sta_op);
    *smooth_smag += Weighted_sum(p->smooth[i], p->smooth[i], p->sta_op);
  }
}
