/*
** initialise a machine with a specified variation in the weights
*/
# include "Tools.h"

void Create_machine(Machine_type *p, int bias, int ninp, int nsta0,
	      int nhid, int nsta1, int nout, double limit) {
  int i, j;
  
  /* set up the start values */
  p->ext_ip   = bias;
  p->sta_ip   = p->ext_ip + ninp;
  p->hidden   = p->sta_ip + nsta0;
  p->sta_op   = p->hidden + nhid;
  p->ext_op   = p->sta_op + nsta1;
  p->length   = p->ext_op + nout;
  p->hid_node = &Unassigned_node;
  p->sta_node = &Unassigned_node;
  p->ext_node = &Unassigned_node;

  /* allocate space to the machine values */
  if((p->node_ip = Make_array(p->length)) == NULL ||
     (p->node_op = Make_array(p->length)) == NULL ||
     (p->delta   = Make_array(p->length)) == NULL ||
     (p->weight  = Make_weight_matrix(p)) == NULL ||
     (p->change  = Make_weight_matrix(p)) == NULL ||
     (p->smooth  = Make_weight_matrix(p)) == NULL)
    Panic("Create_machine: can't allocate storage\n");

  /* set node o/p of bias units to be 1.0, the rest to be 0.0 */
  for(i = 0; i < bias; i++) p->node_op[i] = p->node_ip[i] = 1.0;
  for(i = bias; i < p->length; i++) p->node_op[i] = p->node_ip[i] = 0.0;

  /* set valid weights to be random in range +- limit */
  /* NB **WARNING** ONLY SETS THE FIRST WEIGHT IN THE LINK */
  for(i = p->hidden; i < p->sta_op; i++)
    /*$dir no_recurrence */
    for(j = 0; j < i; j++) {
      p->weight[i][j] = limit * (Ran1(0) - Ran1(0));
      p->change[i][j] = p->smooth[i][j] = 0.0;
    }
  
  for(i = p->sta_op; i < p->length; i++)
    /*$dir no_recurrence */
    for(j = 0; j < p->sta_op; j++) {
      p->weight[i][j] = limit * (Ran1(0) - Ran1(0));
      p->change[i][j] = p->smooth[i][j] = 0.0;
    }
}

void Create_machine_no_smooth(Machine_type *p, int bias, int ninp, int nsta0,
	      int nhid, int nsta1, int nout, double limit) {
  int i, j;
  
  /* set up the start values */
  p->ext_ip   = bias;
  p->sta_ip   = p->ext_ip + ninp;
  p->hidden   = p->sta_ip + nsta0;
  p->sta_op   = p->hidden + nhid;
  p->ext_op   = p->sta_op + nsta1;
  p->length   = p->ext_op + nout;
  p->hid_node = &Unassigned_node;
  p->sta_node = &Unassigned_node;
  p->ext_node = &Unassigned_node;

  /* allocate space to the machine values */
  if((p->node_ip = Make_array(p->length)) == NULL ||
     (p->node_op = Make_array(p->length)) == NULL ||
     (p->delta   = Make_array(p->length)) == NULL ||
     (p->weight  = Make_weight_matrix(p)) == NULL ||
     (p->change  = Make_weight_matrix(p)) == NULL)
    Panic("Create_machine: can't allocate storage\n");

  /* set node o/p of bias units to be 1.0, the rest to be 0.0 */
  for(i = 0; i < bias; i++) p->node_op[i] = p->node_ip[i] = 1.0;
  for(i = bias; i < p->length; i++) p->node_op[i] = p->node_ip[i] = 0.0;

  /* set valid weights to be random in range +- limit */
  /* NB **WARNING** ONLY SETS THE FIRST WEIGHT IN THE LINK */
  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) {
      p->weight[i][j] = limit * (Ran1(0) - Ran1(0));
      p->change[i][j] = 0.0;
    }
  
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p->sta_op; j++) {
      p->weight[i][j] = limit * (Ran1(0) - Ran1(0));
      p->change[i][j] = 0.0;
    }
}
