/* 
** Calculate the deltas and the energy of a machine, from p->ext_op
** to p->length by comparing with the targets
*/
# include "Tools.h"

float Compare(Machine_type *p, float *target) {
  float diff, energy = 0.0;
  int  i;

  for(i = p->ext_op; i < p->length; i++) {
    diff        = target[i - p->ext_op] - p->node_op[i];
    p->delta[i] = p->ext_node->slope(p->node_ip[i], p->node_op[i]) * diff;
    energy     += diff * diff; 
  }
  return(energy);
}

float Compare_eta(Machine_type *p, float *target, double eta) {
  float diff, energy = 0.0;
  int i;

  for(i = p->ext_op; i < p->length; i++) {
    diff        = target[i - p->ext_op] - p->node_op[i];
    p->delta[i] = eta * p->ext_node->slope(p->node_ip[i], p->node_op[i]) *diff;
    energy     += diff * diff; 
  }
  return(energy);
}

float H_compare(Machine_type *p, float *target) {
  float energy = 0.0;
  int i;

  if(p->ext_node == &Usigmoid_node ||
     p->ext_node == &Safe_usigmoid_node ||
     p->ext_node == &Exp_node)		     /* N.B.  Normalisation assumed */
    for(i = p->ext_op; i < p->length; i++) {
      float tar = target[i - p->ext_op], act = p->node_op[i];
      p->delta[i]    = tar - act;
      if(tar != 0.0) energy += tar * log(tar / (act + VERY_SMALL));
#ifdef WANT_OLD_CODE
      if(tar == 0.0) energy -= log(1.0 - act + VERY_SMALL);
      else if(tar == 1.0) energy -= log(act + VERY_SMALL);
      else energy -= tar * log(act + VERY_SMALL) + (1 - tar) * log(1 - act + VERY_SMALL);
#endif
    }
  else {
    for(i = p->ext_op; i < p->length; i++) {
      float tar = target[i - p->ext_op], act = p->node_op[i];
      p->delta[i] = p->ext_node->slope(p->node_ip[i], act) *
	            (tar - act) / (act * (1.0 - act));
      if(tar != 0.0) energy += tar * log(tar / (act + VERY_SMALL));
    }
  }
  return(energy);
}

float H_compare_eta(Machine_type *p, float *target, double eta) {
  float energy = 0.0;
  int i;

  for(i = p->ext_op; i < p->length; i++) {
    float tar = target[i - p->ext_op], act = p->node_op[i];
    p->delta[i] = eta * p->ext_node->slope(p->node_ip[i], act) *
		  (tar - act) / (act * (1.0 - act));
    if(tar != 0.0) energy += tar * log(tar / (act + VERY_SMALL));
  }
  return(energy);
}



