/*
** Change the number of hidden and state units in a machine by 
** hid_diff and sta_diff.   
*/
# include "Tools.h"

void Change_machine(p, hid_diff, sta_diff, limit)
Machine_type *p;
int          hid_diff, sta_diff;
Tools_type   limit;
{
  Machine_type m;
  int i, j;

  /* Create storage for m */
  Create_machine(&m, p->ext_ip, p->sta_ip - p->ext_ip,
		 p->hidden - p->sta_ip + sta_diff,
		 p->sta_op - p->hidden + hid_diff,
		 p->ext_op - p->sta_op + sta_diff,
		 p->length - p->ext_op, limit);

  /* copy over .weight, .change and .smooth from the old to the new machine*/
  for(i = m.hidden, j = p->hidden; i < m.sta_op && j < p->sta_op; i++, j++) {
    int min0, min1;

    min0 = m.hidden < p->hidden ? m.hidden : p->hidden;
    COPY(p->weight[j], m.weight[i], min0);
    COPY(p->change[j], m.change[i], min0);
    COPY(p->smooth[j], m.smooth[i], min0);

    min1 = i - m.hidden < j - p->hidden ? i - m.hidden : j - p->hidden;
    COPY(p->weight[j] + p->hidden, m.weight[i] + m.hidden, min1);
    COPY(p->change[j] + p->hidden, m.change[i] + m.hidden, min1);
    COPY(p->smooth[j] + p->hidden, m.smooth[i] + m.hidden, min1);
  }

  for(i = m.sta_op, j = p->sta_op; i < m.ext_op && j < p->ext_op; i++, j++) {
    int min0, min1;

    min0 = m.hidden < p->hidden ? m.hidden : p->hidden;
    COPY(p->weight[j], m.weight[i], min0);
    COPY(p->change[j], m.change[i], min0);
    COPY(p->smooth[j], m.smooth[i], min0);

    min1 = m.sta_op - m.hidden < p->sta_op - p->hidden ? 
           m.sta_op - m.hidden : p->sta_op - p->hidden;
    COPY(p->weight[j] + p->hidden, m.weight[i] + m.hidden, min1);
    COPY(p->change[j] + p->hidden, m.change[i] + m.hidden, min1);
    COPY(p->smooth[j] + p->hidden, m.smooth[i] + m.hidden, min1);
  }

  for(i = m.ext_op, j = p->ext_op; i < m.length && j < p->length; i++,j++) {
    int min0, min1;

    min0 = m.hidden < p->hidden ? m.hidden : p->hidden;
    COPY(p->weight[j], m.weight[i], min0);
    COPY(p->change[j], m.change[i], min0);
    COPY(p->smooth[j], m.smooth[i], min0);

    min1 = m.sta_op - m.hidden < p->sta_op - p->hidden ? 
           m.sta_op - m.hidden : p->sta_op - p->hidden;
    COPY(p->weight[j] + p->hidden, m.weight[i] + m.hidden, min1);
    COPY(p->change[j] + p->hidden, m.change[i] + m.hidden, min1);
    COPY(p->smooth[j] + p->hidden, m.smooth[i] + m.hidden, min1);
  }
/*
  fprintf(stderr, "free %x\n", p->node_ip);
  fprintf(stderr, "free %x\n", p->node_op);
  fprintf(stderr, "free %x\n", p->delta);
  fprintf(stderr, "free %x\n", p->weight);
  fprintf(stderr, "free %x\n", p->weight[0]);
  fprintf(stderr, "free %x\n", p->change);
  fprintf(stderr, "free %x\n", p->change[0]);
  fprintf(stderr, "free %x\n", p->smooth);
  fprintf(stderr, "free %x\n", p->smooth[0]);

  fprintf(stderr, "alloc %x\n", m.node_ip);
  fprintf(stderr, "alloc %x\n", m.node_op);
  fprintf(stderr, "alloc %x\n", m.delta);
  fprintf(stderr, "alloc %x\n", m.weight);
  fprintf(stderr, "alloc %x\n", m.weight[0]);
  fprintf(stderr, "alloc %x\n", m.change);
  fprintf(stderr, "alloc %x\n", m.change[0]);
  fprintf(stderr, "alloc %x\n", m.smooth);
  fprintf(stderr, "alloc %x\n", m.smooth[0]);
*/
  /* free the storage of the old machine */
  Free_machine(p);  

  /* copy over the new parameters from m to *p */
  p->ext_ip  = m.ext_ip;
  p->sta_ip  = m.sta_ip;
  p->hidden  = m.hidden;
  p->sta_op  = m.sta_op;
  p->ext_op  = m.ext_op;
  p->length  = m.length;
  p->node_ip = m.node_ip;
  p->node_op = m.node_op;
  p->delta   = m.delta;
  p->weight  = m.weight;
  p->change  = m.change;
  p->smooth  = m.smooth;
}
