/* This code copies a section of memory from the B011 node to all the
** other node in the most noddy way possible
*/
# include "Tools.h"

typedef struct data_struct {
  char  *start;
  int	nbyte;
} data_type;


#ifdef TC
Channel *write_down_link1out_channel;

int write_down_link1out(Process *p) {
  static data_type data;

  while(1) {
    ChanIn(write_down_link1out_channel, (char*) &data, sizeof(data));
    ChanOut(LINK1OUT, data.start, data.nbyte);
  }
}
#endif

void Init_write_down_link1out() {
#ifdef TC
  int active = FALSE;

  if(active == FALSE) {
    write_down_link1out_channel = ChanAlloc();
    ProcRun(ProcAlloc(write_down_link1out, 1, 0));
    active = TRUE;
  }
#endif
}

# define MAX_NBYTES 1024

void Distribute(char *data, int size, int destination) {
#ifdef TC
  int nodeid = getnodeid();
  int nbyte;
  
  if(size != 0) {
    if(nodeid == B011_NODEID) {
      for(nbyte = 0; nbyte < size - MAX_NBYTES; nbyte += MAX_NBYTES)
	ChanOut(LINK3OUT, data + nbyte, MAX_NBYTES);
      ChanOut(LINK3OUT, data + nbyte, size - nbyte);
    }
    else if(nodeid < destination) {
      data_type cdata;

      for(nbyte = 0; nbyte < size - MAX_NBYTES; nbyte += MAX_NBYTES) {
	ChanIn(LINK0IN, data + nbyte, MAX_NBYTES);
	cdata.start = data + nbyte;
	cdata.nbyte = MAX_NBYTES;
	ChanOut(write_down_link1out_channel, (char*) &cdata, sizeof(cdata));
      }
      ChanIn(LINK0IN, data + nbyte, size - nbyte);
      cdata.start = data + nbyte;
      cdata.nbyte = size - nbyte;
      ChanOut(write_down_link1out_channel, (char*) &cdata, sizeof(cdata));
    }
    else if(nodeid == destination) {
      for(nbyte = 0; nbyte < size - MAX_NBYTES; nbyte += MAX_NBYTES)
	ChanIn(LINK0IN, data + nbyte, MAX_NBYTES);
      ChanIn(LINK0IN, data + nbyte, size - nbyte);
    }
  }
#endif
}

void Broadcast_word(int *data) {
#ifdef TC
  int nodeid = getnodeid();

  if(nodeid == B011_NODEID) ChanOutInt(LINK3OUT, *data);
  else if(nodeid == LAST_NODEID) *data = ChanInInt(LINK0IN);
  else ChanOutInt(LINK1OUT, *data = ChanInInt(LINK0IN));
#endif
}

# define BLOCK_SIZE 1024
void Broadcast(char *data, int size) {
#ifdef TC
  int nodeid = getnodeid();
  int nbyte;
  
  if(size != 0) {
    if(nodeid == B011_NODEID) {
      for(nbyte = 0; nbyte < size - BLOCK_SIZE; nbyte += BLOCK_SIZE)
	ChanOut(LINK3OUT, data + nbyte, BLOCK_SIZE);
      ChanOut(LINK3OUT, data + nbyte, size - nbyte);
    }
    else if(nodeid == LAST_NODEID) {
      for(nbyte = 0; nbyte < size - BLOCK_SIZE; nbyte += BLOCK_SIZE)
	ChanIn(LINK0IN, data + nbyte, BLOCK_SIZE);
      ChanIn(LINK0IN, data + nbyte, size - nbyte);
    }
    else {
      for(nbyte = 0; nbyte < size - BLOCK_SIZE; nbyte += BLOCK_SIZE) {
	ChanIn(LINK0IN, data + nbyte, BLOCK_SIZE);
	ChanOut(LINK1OUT, data + nbyte, BLOCK_SIZE);
      }
      ChanIn(LINK0IN, data + nbyte, size - nbyte);
      ChanOut(LINK1OUT, data + nbyte, size - nbyte);
    }
  }
#endif
}

/* This piece of code sits on the tadpole transputer and each of the
** T-Rack transputers.  When executed on the Tadpole it broadcasts the
** argc, argv information down LINK3OUT.  When executed on the T-Rack
** transputers it mallocs the appropriate amount of space, receives the
** data down LINK0IN and for all but the last transputer, sends it out
** again using LINK1OUT.
**
** USAGE: The first executable line in main() should be;
**   Broadcast_argc_argv(&argc, &argv);
*/

void Broadcast_argc_argv(int *pargc, char ***pargv) {
#ifdef TC
  int 	argc;
  char  **argv;
  int   i, length, nodeid = getnodeid();

  if(nodeid == B011_NODEID) {
    argc = *pargc;
    argv = *pargv;
    ChanOutInt(LINK3OUT, argc);
    for(i = 0; i < argc; i++) {
      length = strlen(argv[i]) + 1;
      ChanOutInt(LINK3OUT, length);
      ChanOut(LINK3OUT, argv[i], length);
    }
  }
  else if(nodeid >= FIRST_NODEID && nodeid < LAST_NODEID) {
    ChanOutInt(LINK1OUT, argc = ChanInInt(LINK0IN));
    argv = (char**) malloc(argc * sizeof(char*));
    for(i = 0; i < argc; i++) {
      ChanOutInt(LINK1OUT, length = ChanInInt(LINK0IN));
      argv[i] = malloc(length * sizeof(char));
      ChanIn(LINK0IN, argv[i], length);
      ChanOut(LINK1OUT, argv[i], length);
    }
  }
  else if(nodeid == LAST_NODEID) {
    argc = ChanInInt(LINK0IN);
    argv = (char**) malloc(argc * sizeof(char*));
    for(i = 0; i < argc; i++) {
      length = ChanInInt(LINK0IN);
      argv[i] = malloc(length * sizeof(char));
      ChanIn(LINK0IN, argv[i], length);
    }
  }
  *pargc = argc;
  *pargv = argv;
#endif
}

void Reap_array(float *data, int size) {
#ifdef TC
  float tmpf, *end = data + size;
  int   tmpi, nodeid = getnodeid();

  if(nodeid == FIRST_NODEID)
    while(data < end)
      ChanOutInt(LINK1OUT, *((int*) data++));
  else if(nodeid == B011_NODEID)
    while(data < end) {
      tmpi = ChanInInt(LINK2IN);
      *data++ += *((float*) &tmpi);
    }
  else
    while(data < end) {
      tmpi = ChanInInt(LINK0IN);
      tmpf = *data++ + *((float*) &tmpi);
      ChanOutInt(LINK1OUT, *((int*) &tmpf));
    }
#endif
}

void Reap_float(float *data) {
#ifdef TC
  float tmpf;
  int   tmpi, nodeid = getnodeid();

  if(nodeid == FIRST_NODEID) ChanOutInt(LINK1OUT, *((int*) data));
  else if(nodeid == B011_NODEID) {
    tmpi = ChanInInt(LINK2IN);
    *data += *((float*) &tmpi);
  }
  else {
    tmpi = ChanInInt(LINK0IN);
    tmpf = *data + *((float*) &tmpi);
    ChanOutInt(LINK1OUT, *((int*) &tmpf));
  }
#endif
}

/************************************ THIS IS A PROC VERSION OF THE ABOVE
Reap_array(float *array, int size)
{
  int i, nodeid = getnodeid();

  if(nodeid == FIRST_NODEID)
    for(i = 0; i < size; i++) ChanOutFloat(LINK1OUT, array[i]);
  else if(nodeid == B011_NODEID)
    for(i = 0; i < size; i++) array[i] += ChanInFloat(LINK0IN);
  else
    for(i = 0; i < size; i++)
      ChanOutFloat(LINK1OUT, array[i] + ChanInFloat(LINK0IN));
}
*************************************************************************/
