/*
** do a backward pass through a general machine
*/
# include "Tools.h"

void Backward(Machine_type *p) {
  int i;

  /* zero the delta space which is used as a running sum */
  for(i = p->sta_ip; i < p->sta_op; i++) p->delta[i] = 0.0;

  /* for all the external output units */
  for(i = p->ext_op; i < p->length; i++)
    p->ext_node->reverse(p->weight[i] + p->sta_ip, p->delta + p->sta_ip, 
		 p->sta_op - p->sta_ip, p->delta[i]);

  /* for all the state output units */
  for(i = p->sta_op; i < p->ext_op; i++)
    p->sta_node->reverse(p->weight[i] + p->sta_ip, p->delta + p->sta_ip,
		 p->sta_op - p->sta_ip, p->delta[i]);

  /* for all the hidden units, in reverse order */
  for(i = p->sta_op - 1; i >= p->hidden; i--) {
    p->delta[i] *= p->hid_node->slope(p->node_ip[i], p->node_op[i]);
    p->hid_node->reverse(p->weight[i] + p->sta_ip, p->delta + p->sta_ip,
                 i - p->sta_ip, p->delta[i]);
  }

  /* for all the state input units */
  for(i = p->sta_ip; i < p->hidden; i++)
    p->delta[i] *= p->sta_node->slope(p->node_ip[i], p->node_op[i]);
}

/*
** do a backward pass through a general machine
** calculate weight changes and accumulate
** WARNING: ASSUMES WEIGHTED SUM TYPE NODES...
*/

void Backward_accumulate(Machine_type *p) {
  int i;

  /* zero the delta space which is used as a running sum */
  for(i = p->sta_ip; i < p->sta_op; i++) p->delta[i] = 0.0;

  /* for all the output units */
  for(i = p->sta_op; i < p->length; i++) {
    Scale_one_vector(p->node_op, p->change[i], p->sta_ip, p->delta[i]);
    Scale_two_vectors(p->node_op   + p->sta_ip,
		      p->delta     + p->sta_ip,
		      p->weight[i] + p->sta_ip,
		      p->change[i] + p->sta_ip,
		      p->sta_op    - p->sta_ip, p->delta[i]);
  }

  /* for all the hidden units, in reverse order */
  for(i = p->sta_op - 1; i >= p->hidden; i--) {
    p->delta[i] *= p->hid_node->slope(p->node_ip[i], p->node_op[i]);
    Scale_one_vector(p->node_op, p->change[i], p->sta_ip, p->delta[i]);
    Scale_two_vectors(p->node_op   + p->sta_ip,
		      p->delta     + p->sta_ip,
		      p->weight[i] + p->sta_ip,
		      p->change[i] + p->sta_ip,
		      i - p->sta_ip, p->delta[i]);
  }

  /* for all the state input units */
  for(i = p->sta_ip; i < p->hidden; i++)
    p->delta[i] *= p->sta_node->slope(p->node_ip[i], p->node_op[i]);
}

/*
** do a backward pass through a general machine
*/

void Backward_all(Machine_type *p) {
  int i;

  /* zero the delta space which is used as a running sum */
  for(i = p->ext_ip; i < p->sta_op; i++) p->delta[i] = 0.0;

  /* for all the external output units */
  for(i = p->ext_op; i < p->length; i++)
    p->ext_node->reverse(p->weight[i] + p->ext_ip, p->delta + p->ext_ip,
		 p->sta_op - p->ext_ip, p->delta[i]);

  /* for all the state output units */
  for(i = p->sta_op; i < p->ext_op; i++)
    p->sta_node->reverse(p->weight[i] + p->ext_ip, p->delta + p->ext_ip,
		 p->sta_op - p->ext_ip, p->delta[i]);

  /* for all the hidden units, in reverse order */
  for(i = p->sta_op - 1; i >= p->hidden; i--) {
    p->delta[i] *= p->hid_node->slope(p->node_ip[i], p->node_op[i]);
    p->hid_node->reverse(p->weight[i] + p->ext_ip, p->delta + p->ext_ip,
		 i - p->ext_ip, p->delta[i]);
  }

  /* for all the external input and state input units */
  /* N.B. it is assumed that external nodes have the same activation fn */
  for(i = p->ext_ip; i < p->hidden; i++)
    p->delta[i] *= p->sta_node->slope(p->node_ip[i], p->node_op[i]);
}

