# include "Tools.h"
# include "Timit.h"

# define NINDEX		32768
# define INDEX_SCALE	1024
# define OVERFLOW_PROBABILITY (1.0 / 512.0)
# define DEFAULT_GAP	8.0
# define BYTE_SIZE	(1 << 8)

void swap4(char *data) {
  char tmp;
  tmp = data[0];
  data[0] = data[3];
  data[3] = tmp;
  tmp = data[1];
  data[1] = data[2];
  data[2] = tmp;
}

int main(int argc, char **argv) {
  FILE  *fp_ftrn, *fp_ftst, *fp_btst;
  double *mean, *stdd;
  float *buffer, *offset, *scale;
  float crange, gap;
  int	**noccur, *noverflow, *nunderflow;
  int	linear, swap, verbose, phone, ninp, nframe, nlimit, i, j;
  uchar uchar_phone, *uchar_buffer;

  if(Scan_flag(argc, argv, "-h") || argc < 4 ||
     (fp_ftrn = fopen(argv[argc - 3], "r")) == NULL ||
     (fp_ftst = Std_fopen(argv[argc - 2], "r")) == NULL ||
     (fp_btst = Std_fopen(argv[argc - 1], "w")) == NULL) {
    fprintf(stderr, "Syntax:\t%s\n", *argv);
    fprintf(stderr, "\t-byte\n");
    fprintf(stderr, "\t-swap\n");
    fprintf(stderr, "\t-linear\n");
    fprintf(stderr, "\t-verbose\n");
    fprintf(stderr, "\t-ninp %d\n", TIMIT_DEFAULT_NINP);
    fprintf(stderr, "\t-gap %f\n", DEFAULT_GAP);
    fprintf(stderr, "\t<float train file>\n");
    fprintf(stderr, "\t<-|float test file>\n");
    fprintf(stderr, "\t<-|byte test file>\n");
    exit(1);
  }

  swap    = Scan_flag(argc, argv, "-swap");
  linear  = Scan_flag(argc, argv, "-linear");
  verbose = Scan_flag(argc, argv, "-verbose");
  ninp    = Scan_int(argc, argv, "-ninp", TIMIT_DEFAULT_NINP);
  gap     = Scan_double(argc, argv, "-gap", DEFAULT_GAP);
  crange  = MAX_UCHAR - 2.0 * gap;

  buffer = Panic_float_array(ninp);
  mean   = Panic_double_array(ninp);
  stdd   = Panic_double_array(ninp);
  offset = Panic_float_array(ninp);
  scale  = Panic_float_array(ninp);
  noccur = Panic_int_2d_array(ninp, NINDEX);
  noverflow  = Panic_int_array(ninp);
  nunderflow = Panic_int_array(ninp);
  uchar_buffer = Panic_uchar_array(ninp);

  for(i = 0; i < ninp; i++) mean[i] = stdd[i] = 0.0;

  for(i = 0; i < ninp; i++)
    for(j = 0; j < NINDEX; j++) noccur[i][j] = 0;

  if(Scan_flag(argc, argv, "-byte")) {
    for(nframe = 0; fread((char*) &phone, sizeof(phone), 1, fp_ftrn) == 1 &&
	fread((char*) buffer, sizeof(*buffer), ninp, fp_ftrn) ==ninp;nframe++){

      if(swap) swap4((char*) &phone);
      uchar_phone = phone;
      Panic_fwrite(&uchar_phone, sizeof(uchar_phone), 1, fp_btst);

      for(i = 0; i < ninp; i++) {
	int possval;

	if(swap) swap4((char*) (&buffer[i]));
	if(finite(buffer[i]) != 1)
	  Panic("%s:\t%d\t%d\t%f\n", *argv, nframe, i, buffer[i]);
	possval = 256.0 * buffer[i];
	if(possval > 255) possval = 255;
	else if(possval < 0) possval = 0;
	uchar_buffer[i] = possval;
      }
      Panic_fwrite(uchar_buffer, sizeof(*uchar_buffer), ninp, fp_btst);
    }
  }
  else {
    for(nframe = 0; fread((char*) &phone, sizeof(phone), 1, fp_ftrn) == 1 &&
	fread((char*) buffer, sizeof(*buffer), ninp, fp_ftrn) ==ninp;nframe++){
      for(i = 0; i < ninp; i++) {
	if(swap) swap4((char*) (&buffer[i]));
	if(finite(buffer[i]) != 1)
#ifdef DEBUG
	  printf("%s:\t%d\t%d\t%f\n", *argv, nframe, i, buffer[i]);
#else
          Panic("%s:\t%d\t%d\t%f\n", *argv, nframe, i, buffer[i]);
#endif
	mean[i] += buffer[i];
	stdd[i] += buffer[i] * buffer[i];
      }
    }
    
    for(i = 0; i < ninp; i++) {
      mean[i] /= nframe;
      stdd[i] = sqrt(stdd[i] / nframe - mean[i] * mean[i]);
    }

    if(verbose)
      for(i = 0; i < ninp; i++)
	printf("Channel: %d\tMean: %f\tStdd: %f\n", i, mean[i], stdd[i]);

    rewind(fp_ftrn);

    for(i = 0; i < ninp; i++) nunderflow[i] = noverflow[i] = 0.0;
    for(nframe = 0; fread((char*) &phone, sizeof(phone), 1, fp_ftrn) == 1 && 
	fread((char*) buffer, sizeof(*buffer), ninp, fp_ftrn) ==ninp;nframe++){
      for(i = 0; i < ninp; i++) {
	int index;

	if(swap) swap4((char*) &buffer[i]);
	
	index = floor(INDEX_SCALE * (buffer[i] - mean[i]) / stdd[i] + 
		      NINDEX / 2 + 0.5);
	if(index < 0) {
	  index = 0;
	  nunderflow[i]++;
	}
	if(index >= NINDEX) {
	  index = NINDEX - 1;
	  noverflow[i]++;
	}
	noccur[i][index]++;
      }
    }

    for(i = 0; i < ninp; i++)
      if(nunderflow[i] != 0 || noverflow[i] != 0)
	fprintf(stderr, "%s: Channel %d\tUnderflow: %d\tOverflow: %d\n",
		*argv, i, nunderflow[i], noverflow[i]);
    rewind(fp_ftst);

    for(i = 0; i < ninp; i++) nunderflow[i] = noverflow[i] = 0.0;
    if(Scan_flag(argc, argv, "-linear") == FALSE) {
      for(i = 0; i < ninp; i++) {
	int sum = 0;

	for(j = 0; j < NINDEX; j++) {
	  sum += noccur[i][j];
	  noccur[i][j] = sum * BYTE_SIZE / (nframe + 1);
	}
      }

      for(nframe = 0; fread((char*) &phone, sizeof(phone), 1, fp_ftst) == 1 && 
	  fread((char*) buffer, sizeof(*buffer), ninp,fp_ftst)==ninp;nframe++){
	if(swap) swap4((char*) &phone);
	uchar_phone = phone;
	for(i = 0; i < ninp; i++) {
	  int index;

	  if(swap) swap4((char*) &buffer[i]);

	  index = floor(INDEX_SCALE * (buffer[i] - mean[i]) / stdd[i] + 
			NINDEX / 2 + 0.5);
	  if(index < 0) index = 0;
	  if(index >= NINDEX) index = NINDEX - 1;

	  uchar_buffer[i] = noccur[i][index];
	}
	Panic_fwrite(&uchar_phone, sizeof(uchar_phone), 1, fp_btst);
	Panic_fwrite(uchar_buffer, sizeof(*uchar_buffer), ninp, fp_btst);
      }
    }
    else {
      nlimit = floor(nframe * OVERFLOW_PROBABILITY + 0.5);
      if(verbose) printf("nlimit: %d\n", nlimit);

      for(i = 0; i < ninp; i++) {
	int sum, lolimit, hilimit;
      
	for(j = 0, sum = 0; j < NINDEX && (sum += noccur[i][j]) < nlimit; j++);
	lolimit = j;

	for(j = NINDEX - 1, sum = 0; j >= 0&&(sum += noccur[i][j])<nlimit;j--);
	hilimit = j;
      
	offset[i] = (lolimit - NINDEX / 2) * stdd[i] / INDEX_SCALE + mean[i];
	scale[i] = crange / ((hilimit - lolimit) * stdd[i] / INDEX_SCALE);
      }

      for(nframe = 0; fread((char*) &phone, sizeof(phone), 1, fp_ftst) == 1 && 
	  fread((char*) buffer, sizeof(*buffer), ninp,fp_ftst)==ninp;nframe++){
	if(swap) swap4((char*) &phone);
	uchar_phone = phone;
	for(i = 0; i < ninp; i++) {
	  int index;

	  if(swap) swap4((char*) &buffer[i]);

	  index = floor(scale[i] * (buffer[i] - offset[i]) + gap + 0.5);
	  if(index < 0) {
	    index = 0;
	    nunderflow[i]++;
	  }
	  else if(index > MAX_UCHAR) {
	    index = MAX_UCHAR;
	    noverflow[i]++;
	  }
	  uchar_buffer[i] = index;
	}
	Panic_fwrite(&uchar_phone, sizeof(uchar_phone), 1, fp_btst);
	Panic_fwrite(uchar_buffer, sizeof(*uchar_buffer), ninp, fp_btst);
      }
  
      if(verbose)
	for(i = 0; i < ninp; i++) {
	  printf("channel: %d\tlo: %f\thi: %f\t", i,
		 (0 - gap) / scale[i] + offset[i],
		 (MAX_UCHAR - gap) / scale[i] + offset[i]);
	  if(nunderflow[i] != 0) printf("< %d\t", nframe / nunderflow[i]);
	  else printf("< none\t");
	  if(noverflow[i] != 0) printf("> %d\n", nframe / noverflow[i]);
	  else printf("> none\n");
	}
    }
  }
  return(0);
}
