# include "Tools.h"
# include "Timit.h"
# include "RM.h"

# define DEFAULT_FRAME	256
# define DEFAULT_PHNTAB	TIMIT_DEFAULT_PHNTAB

int main(int argc, char **argv) {
  FILE	*fact, *fdur;
  float **markova, **dist, **best_dist;
  int   **best_from, *best_posn;
  int	i, j, k, nframe, nphone, framesize, frame, timing;
  char  **phntab;
  uchar **data;

  if(Scan_flag(argc, argv, "-h") == TRUE || argc < 3 ||
     (fact = fopen(argv[argc - 2], "r+")) == NULL ||
     (fdur = fopen(argv[argc - 1], "r")) == NULL) {
    fprintf(stderr, "Syntax:\t%s\n", *argv);
    fprintf(stderr, "\t-timing\n");
    fprintf(stderr, "\t-frame %d\n", DEFAULT_FRAME);
    fprintf(stderr, "\t-phntab %s\n", DEFAULT_PHNTAB);
    fprintf(stderr, "\t<activation file>\n");
    fprintf(stderr, "\t<transition probability file>\n");
    exit(1);
  }

  timing = Scan_flag(argc, argv, "-timing");
  frame  = Scan_float(argc, argv, "-frame", DEFAULT_FRAME);
  phntab = Read_table(Scan_string(argc,argv,"-phntab",DEFAULT_PHNTAB),&nphone);
  framesize = nphone + 1;

  fseek(fact, 0, 2);
  nframe = ftell(fact) / framesize;
  if(ftell(fact) != framesize * nframe)
    Panic("%s: Not an integer number of frames: %s\n", argv[0], argv[argc-2]);
  rewind(fact);
  
  markova	= Panic_float_2d_array(nphone, nphone);
  dist		= Panic_float_2d_array(nframe, nphone);
  data		= Panic_uchar_2d_array(nframe, framesize);
  best_dist	= Panic_float_2d_array(nframe + 1, nphone);
  best_from	= Panic_int_2d_array(nframe + 1, nphone);
  best_posn	= Panic_int_array(nframe);

  Panic_fread((char*) *markova, sizeof(float) * nphone, nphone, fdur);
  Panic_fread((char*) *data, framesize, nframe, fact);

  for(j = 0; j < nphone; j++) best_dist[0][j] = 0.0;

  for(i = 0; i < nframe; i++) {
    for(j = 0; j < nphone; j++) best_dist[i + 1][j] = VERY_BIG;

    for(j = 0; j < nphone; j++) {
      float bestsofar = best_dist[i][j] + 
	(float) data[i][j + 1] / (float) LNPROB_FLOAT2INT;
      float *next_best_dist = best_dist[i + 1];
      float *markova_j = markova[j];

      for(k = 0; k < nphone; k++)
	if(bestsofar + markova_j[k] < next_best_dist[k]) {
	  next_best_dist[k] = bestsofar + markova_j[k];
	  best_from[i + 1][k] = j;
	}
    }
  }

  j = 0;
  for(k = j + 1; k < nphone; k++)
    if(best_dist[nframe][k] < best_dist[nframe][j]) j = k;

  for(i = nframe; i > 0; i--) {
    j = best_from[i][j];
    best_posn[i - 1] = j;
  }

  {
    int last_symb = best_posn[0];
    int last_posn = 0;
    
    for(i = 1; i <= nframe; i++)
      if(i == nframe || best_posn[i] != last_symb) {
	printf(timing ? "%d\t%d\t%s\t" : "%d\t%d\t%s\n", last_posn * frame,
	       i * frame, phntab[best_posn[i - 1]]);
	if(timing) {
	  int done = 0;
	  for(j = last_posn + 1; !done && j < nframe; j++) {
	    int k;
	    done = 1;
	    for(k = 0; k < nphone; k++) {
	      int l, bestp = k;
	      for(l = j; l > last_posn; l--) bestp = best_from[l][bestp];
	      if(bestp != last_symb) done = 0;
	    }
	  }
	  printf("%d\n", j - (last_posn + 1));
	}
	last_symb = best_posn[i];
	last_posn = i;
      }
  }
  return(0);
}
