# include "Tools.h"
# include "RM.h"

# define DEFAULT_WORD	"/home/dsl1/ajr/lib/rm1_wpg.dct"
# define DEFAULT_GRAM	"/home/dsl1/ajr/rm1_doc/wp_gram.txt"
# define DEFAULT_WPLIST	RM1_DEFAULT_WPLIST

void readgram(char*, char**, char**, int);

int main(int argc, char **argv) {
  FILE	*fwplist; 
  char  **wordtab;
  char  **wptab;
  int   verbose, i, j, nword, initsilence, quitsilence;

  if(Scan_flag(argc, argv, "-h") || argc < 1) {
    fprintf(stderr, "Syntax:\t%s\n", *argv);
    fprintf(stderr, "\t-nowp\n");
    fprintf(stderr, "\t-verbose\n");
    fprintf(stderr, "\t-word %s\n", DEFAULT_WORD);
    fprintf(stderr, "\t-gram %s\n", DEFAULT_GRAM);
    fprintf(stderr, "\t-sent <no default>\n");
    fprintf(stderr, "\t-wplist %s\n", DEFAULT_WPLIST);
    exit(1);
  }
  verbose = Scan_flag(argc, argv, "-verbose");
  fwplist = Panic_fopen(Scan_string(argc, argv, "-wplist",DEFAULT_WPLIST),"w");
  wordtab = Read_table(Scan_string(argc, argv, "-word", DEFAULT_WORD), &nword);
  for(i = 0; i < nword; i++) (void) strtok(wordtab[i], " \t");
  wptab	  = Panic_char_2d_array(nword, nword);
  initsilence = String2index("@INIT", wordtab, nword);
  quitsilence = String2index("@QUIT", wordtab, nword);

  if(Scan_flag(argc, argv, "-nowp"))
    for(i = 0; i < nword; i++)
      for(j = 0; j < nword; j++)
	wptab[i][j] = TRUE;
  else if(Scan_flag(argc, argv, "-sent")) {
    FILE *stream = Panic_fopen(Scan_string(argc, argv, "-sent"), "r");
    char word[RM_WORD_LABEL_SIZE + 1];
    int curr, last = initsilence;

    for(i = 0; i < nword; i++)
      for(j = 0; j < nword; j++)
	wptab[i][j] = FALSE;
    
    while(fscanf(stream, "%*d%*d%s", word) == 1) {
      curr = String2index(word, wordtab, nword);
      wptab[last][curr] = TRUE;
      last = curr;
    }
    wptab[last][quitsilence] = TRUE;
    Panic_fclose(stream);
  }
  else
    readgram(Scan_string(argc, argv, "-gram", DEFAULT_GRAM), wordtab, wptab,
	     nword);

  if(verbose)
    for(i = 0; i < nword; i++)
      for(j = 0; j < nword; j++)
	if(wptab[i][j])
	  printf("%s\t%s\n", wordtab[i], wordtab[j]);

  for(i = 0; i < nword; i++) {
    short word;

    for(word = 0; word < nword; word++)
      if(wptab[i][word])
	Panic_fwrite((char*) &word, sizeof(word), 1, fwplist);

    word = RM_NOTAWORD;
    Panic_fwrite((char*) &word, sizeof(word), 1, fwplist);
  }
  return(0);
}

void readgram(char *filename, char **wordtab, char **wptab, int nword) {
  FILE	*fp_txt;
  int   textsize, linesize, prev, curr, valid = FALSE;
  int   nentries = 0;
  char  *text, *line;
  int	initsilence = String2index("@INIT", wordtab, nword);
  int	quitsilence = String2index("@QUIT", wordtab, nword);

  for(prev = 0; prev < nword; prev++)
    for(curr = 0; curr < nword; curr++)
      wptab[prev][curr] = FALSE;

  fp_txt = Panic_fopen(filename, "r");
  Panic_fseek(fp_txt, (long) 0, 2);
  textsize = ftell(fp_txt);
  text = Panic_malloc(textsize);
  Panic_fseek(fp_txt, (long) 0, 0);
  Panic_fread(text, 1, textsize, fp_txt);
  Panic_fclose(fp_txt);

  for(line = text; line < text + textsize; line +=linesize) {

    for(linesize = 0; line[linesize] != '\n' && 
	line + linesize < text + textsize; linesize++);
    line[linesize++] = '\0';

    if(line[0] == '>') {
      if(strcmp("SENTENCE-END", line + 1) == 0) prev = initsilence;
      else prev = String2index(line + 1, wordtab, nword);
      valid = TRUE;
    }
    else if(valid == TRUE) {
      if(strcmp("SENTENCE-END", line + 1) == 0) curr = quitsilence;
      else curr = String2index(line + 1, wordtab, nword);
      wptab[prev][curr] = TRUE;
      nentries++;
    }
  }
}
