/*************************************************************************/
/*                                                                       */
/*                            LD-CELP  G.728                             */
/*                                                                       */
/*    Low-Delay Code Excitation Linear Prediction speech compression.    */
/*                                                                       */
/*                 Copyright: Analog Devices, Inc., 1993                 */
/*                                                                       */
/*                         Author: Alex Zatsman.                         */
/*                                                                       */
/*  This program was written mostly for testing  Analog Devices' g21k C  */
/*  compiler for the  ADSP21000 architecture  family. While the program  */
/*  works  on  Sparc and ADSP21020, it  has  NOT  been  tested with the  */
/*  official test data from CCITT/ITU.                                   */
/*                                                                       */
/*  The program  is   distributed as  is,  WITHOUT ANY WARRANTY, EITHER  */
/*  EXPLICIT OR IMPLIED.                                                 */
/*                                                                       */
/*************************************************************************/

#include "common.h"
#include "data.h"

real CBMEM cb_shape[128][5] =
{
/*   0 */  { 0.32617188, -1.44042969, -0.61230469, -0.87402344, -1.24658203},
/*   1 */  {-2.45703125, -2.23486328, -0.51025391,  1.41992188,  1.62011719},
/*   2 */  {-1.37646484, -1.30712891, -0.46289062, -1.37939453, -2.17285156},
/*   3 */  {-3.26123047, -0.16601562,  0.72363281, -0.62304688,  0.61621094},
/*   4 */  {-0.27441406, -3.29931641,  0.62548828,  0.08740234, -0.62207031},
/*   5 */  {-1.22656250, -3.48144531, -2.40478516,  3.37548828,  1.17724609},
/*   6 */  {-1.20996094, -0.07617188,  2.28662109, -1.89111328,  0.00000000},
/*   7 */  {-4.00781250,  1.04492188, -0.23339844, -1.35986328,  0.26025391},
/*   8 */  { 0.92236328,  1.34716797,  0.67431641, -3.39599609, -2.88720703},
/*   9 */  { 2.48144531, -1.20117188, -2.82128906,  0.87744141,  0.27734375},

/*  10 */  {-1.07812500, -1.61572266, -2.20849609, -3.04492188, -3.66455078},
/*  11 */  {-1.32763672,  2.12792969, -1.45898438, -0.56103516,  1.30078125},
/*  12 */  { 0.61474609,  0.48583984,  1.32373047, -1.20312500, -5.07324219},
/*  13 */  { 0.84082031, -3.69580078, -1.33886719,  1.06005859, -1.13720703},
/*  14 */  { 0.50390625,  0.36474609, -0.41894531, -3.87988281, -6.27099609},
/*  15 */  { 1.51660156,  2.37109375, -2.04736328, -1.24072266,  0.50537109},
/*  16 */  { 0.90917969, -0.46875000, -3.23632812,  0.20019531,  2.87207031},
/*  17 */  {-1.21728516, -1.28320312, -1.95312500, -0.02929688,  3.51660156},
/*  18 */  {-1.30468750,  0.70605469,  0.75000000, -1.87060547,  0.60205078},
/*  19 */  {-2.58886719,  3.37500000,  0.77587891, -2.04443359,  1.78955078},

/*  20 */  {-1.68750000, -3.98925781, -3.76416016,  0.67578125,  2.29394531},
/*  21 */  {-2.29443359, -3.03173828, -5.45703125,  3.95703125,  8.21777344},
/*  22 */  { 0.45410156,  3.41992188,  0.61962891, -4.38330078,  1.25341797},
/*  23 */  { 2.27001953,  5.76367188,  1.68017578, -2.76220703,  0.58544922},
/*  24 */  { 1.24121094, -0.08935547, -4.32568359, -3.89453125,  1.57714844},
/*  25 */  {-1.40234375, -0.98193359, -4.74267578, -4.09423828,  6.33935547},
/*  26 */  { 1.50683594,  1.04492188, -1.79687500, -4.70849609, -1.41406250},
/*  27 */  {-3.71533203,  3.18115234, -1.11474609, -1.23144531,  3.09179688},
/*  28 */  {-1.62744141, -2.74414062, -4.45800781, -5.43505859,  2.70654297},
/*  29 */  {-0.19873047, -3.28173828, -8.52832031, -1.41064453,  5.64843750},

/*  30 */  { 1.80273438,  3.31835938, -0.12792969, -5.29589844, -0.90625000},
/*  31 */  { 3.55224609,  6.54492188, -1.45947266, -5.17333984,  2.41015625},
/*  32 */  { 0.11914062, -1.08349609,  1.29687500,  1.84375000, -2.64257812},
/*  33 */  {-1.97412109, -2.89746094,  1.04052734,  0.42138672, -1.30175781},
/*  34 */  {-1.61230469,  0.85107422, -0.97949219, -0.06250000, -1.00195312},
/*  35 */  {-3.10595703,  1.63183594, -0.77294922, -0.01025391,  0.55761719},
/*  36 */  {-1.87353516, -0.89404297,  3.12353516,  1.24267578, -1.39062500},
/*  37 */  {-4.55664062, -3.18750000,  2.59228516,  0.96972656, -1.09619141},
/*  38 */  {-2.19238281,  0.36523438,  0.94482422, -1.47802734, -0.24072266},
/*  39 */  {-4.51904297,  2.62011719,  1.55908203, -2.19384766,  0.87109375},

/*  40 */  { 2.33593750, -0.18066406,  0.91113281,  0.51611328, -0.92236328},
/*  41 */  { 3.58496094, -1.31347656, -1.25830078,  0.33007812, -0.29833984},
/*  42 */  {-0.24511719,  1.09130859, -0.90332031, -0.86767578, -1.00048828},
/*  43 */  { 0.49365234,  1.89453125, -1.20361328,  1.07861328, -0.07421875},
/*  44 */  { 1.26562500,  1.38134766,  2.72851562,  1.38623047, -3.56738281},
/*  45 */  {-1.48876953, -2.40136719,  2.90771484,  4.49267578, -2.17138672},
/*  46 */  { 0.34033203,  1.90820312,  2.83105469, -2.17333984, -2.26757812},
/*  47 */  {-1.03564453,  2.65820312, -1.25488281,  0.15673828, -0.58691406},
/*  48 */  { 1.38964844, -1.01855469,  1.72460938,  0.27636719, -0.34570312},
/*  49 */  {-2.08935547,  0.46386719,  2.43164062,  1.83056641,  0.22070312},

/*  50 */  {-1.21289062,  1.70996094,  0.83935547, -0.08300781,  0.11621094},
/*  51 */  {-1.67724609,  0.12841797,  1.03222656, -0.97900391,  1.15283203},
/*  52 */  { 3.58300781, -0.58984375,  4.56396484, -0.59375000, -1.95947266},
/*  53 */  {-6.54736328, -0.21435547,  3.91992188, -2.06640625,  0.17626953},
/*  54 */  {-1.82080078,  2.65283203,  0.97851562, -2.30810547, -0.61474609},
/*  55 */  {-1.94628906,  3.78076172,  4.11572266, -1.80224609, -0.48193359},
/*  56 */  { 2.53808594, -0.20654297,  0.56152344, -0.62548828,  0.39843750},
/*  57 */  { 3.61767578,  2.00634766, -1.92822266,  1.31347656,  0.01464844},
/*  58 */  { 0.60839844,  1.49169922, -0.01708984, -0.66894531, -0.12011719},
/*  59 */  {-0.72705078,  2.75146484, -0.33105469, -1.28271484,  1.54785156},

/*  60 */  { 2.35839844, -2.23876953,  0.98046875, -0.51855469,  0.39013672},
/*  61 */  {-0.06298828,  0.35009766,  2.24316406,  7.29345703,  5.22753906},
/*  62 */  { 0.20361328,  1.34716797,  0.90332031, -2.46923828, -0.56298828},
/*  63 */  {-1.89794922,  3.59423828, -2.81640625,  2.09228516,  0.32519531},
/*  64 */  { 0.70458984, -0.45800781,  0.00976562, -1.03466797, -0.82861328},
/*  65 */  {-1.81250000, -1.66113281, -1.08007812,  0.05371094,  1.04296875},
/*  66 */  {-1.44140625,  0.00585938, -0.76562500, -1.70898438, -0.90576172},
/*  67 */  {-0.64208984, -0.84521484,  0.56640625, -0.27246094,  0.83447266},
/*  68 */  { 0.04296875, -2.23095703,  0.09472656, -0.22167969, -1.44384766},
/*  69 */  {-1.38623047, -0.81347656, -0.14306641,  1.01757812, -0.07568359},

/*  70 */  {-0.09228516, -1.16015625,  0.81201172, -0.50781250, -1.19580078},
/*  71 */  {-1.38769531, -0.66845703,  0.31054688, -0.12109375, -1.30712891},
/*  72 */  { 0.74072266,  0.03857422, -1.47119141, -1.79150391, -0.47509766},
/*  73 */  { 0.93408203, -1.21728516, -2.59375000, -0.36572266,  0.62060547},
/*  74 */  {-1.41748047, -1.62304688, -1.83398438, -1.80175781, -0.89306641},
/*  75 */  {-1.42236328, -5.63818359, -1.34765625, -0.68652344,  0.54882812},
/*  76 */  { 0.90039062, -0.89550781,  0.22265625,  0.34472656, -2.08593750},
/*  77 */  { 0.22802734, -2.07812500, -0.93212891,  0.74267578,  0.55371094},
/*  78 */  {-0.06201172, -0.48535156, -0.31103516, -0.72802734, -3.17089844},
/*  79 */  { 0.42626953, -0.99853516, -1.86914062, -1.36328125, -0.28222656},

/*  80 */  { 1.12841797, -0.88720703,  1.28515625, -1.49023438,  0.96093750},
/*  81 */  { 0.31298828,  0.58300781,  0.92431641,  2.00537109,  3.09667969},
/*  82 */  {-0.02197266,  0.58496094,  1.05468750, -0.72216797,  1.07568359},
/*  83 */  {-0.97851562,  0.83642578,  1.71777344,  1.29492188,  2.07568359},
/*  84 */  { 1.43359375, -1.93750000,  0.62500000,  0.06396484, -0.72070312},
/*  85 */  { 1.38037109,  0.00390625, -0.94140625,  1.29785156,  1.71533203},
/*  86 */  { 1.56201172, -0.39843750,  1.31201172, -0.85009766, -0.68701172},
/*  87 */  { 1.43945312,  1.96728516,  0.19238281, -0.12353516,  0.63378906},
/*  88 */  { 2.09277344,  0.02490234, -2.20068359, -0.01562500, -0.32177734},
/*  89 */  { 1.90576172,  2.75683594, -2.72851562, -1.26562500,  2.78662109},

/*  90 */  {-0.29638672,  0.60253906, -0.78466797, -2.53271484,  0.32421875},
/*  91 */  {-0.25634766,  1.76757812, -1.07031250, -1.23388672,  0.83349609},
/*  92 */  { 2.09814453, -1.58740234, -1.11474609,  0.39648438, -1.10546875},
/*  93 */  { 2.81494141,  0.25781250, -1.60498047,  0.66015625,  0.81640625},
/*  94 */  { 1.33544922,  0.60595703, -0.53857422, -1.59814453, -1.66357422},
/*  95 */  { 1.96923828,  0.80468750, -1.44775391, -0.57324219,  0.70507812},
/*  96 */  { 0.03613281,  0.44824219,  0.97607422,  0.44677734, -0.50097656},
/*  97 */  {-1.21875000, -0.78369141,  0.99316406,  1.44042969,  0.11181641},
/*  98 */  {-1.05859375,  0.99462891,  0.00732422, -0.61718750, -0.10156250},
/*  99 */  {-1.73437500,  0.74707031,  0.28369141,  0.72802734,  0.46972656},

/* 100 */  {-1.27587891, -1.14160156,  1.76806641, -0.72656250, -1.06689453},
/* 101 */  {-0.85302734,  0.03955078,  2.70410156,  0.69921875, -1.10205078},
/* 102 */  {-0.49755859,  0.42333984,  0.10449219, -1.11523438, -0.07373047},
/* 103 */  {-0.82226562,  1.37500000, -0.11181641,  0.12255859, -0.67822266},
/* 104 */  { 1.32177734,  0.24609375,  0.23388672,  1.35888672, -0.49267578},
/* 105 */  { 1.22900391, -0.72607422, -0.77929688,  0.30322266,  0.94189453},
/* 106 */  {-0.07226562,  1.07714844, -2.09375000,  0.63085938, -0.68408203},
/* 107 */  {-0.25732422,  0.60693359, -1.33349609,  0.93212891,  0.62500000},
/* 108 */  { 1.04931641, -0.73291016,  1.80078125,  0.29785156, -2.24169922},
/* 109 */  { 1.61425781, -1.64453125,  0.91552734,  1.77539062, -0.59423828},

/* 110 */  { 1.25683594,  1.22705078,  0.70751953, -1.50097656, -2.43115234},
/* 111 */  { 0.39746094,  0.89160156, -1.21923828,  2.06738281, -1.99072266},
/* 112 */  { 0.81250000, -0.10742188,  1.66894531,  0.48925781,  0.54443359},
/* 113 */  { 0.38134766,  0.80957031,  1.91357422,  2.99316406,  1.53320312},
/* 114 */  { 0.56054688,  1.98486328,  0.74023438,  0.39794922,  0.09716797},
/* 115 */  { 0.58154297,  1.21533203,  1.25048828,  1.18212891,  1.19287109},
/* 116 */  { 0.37597656, -2.88818359,  2.69287109, -0.17968750, -1.56201172},
/* 117 */  { 0.58105469,  0.51123047,  1.82714844,  3.38232422, -10.20458984},
/* 118 */  { 0.14257812,  1.51318359,  2.10351562, -0.37011719, -1.19873047},
/* 119 */  { 0.25537109,  1.91455078,  1.97460938,  0.67675781,  0.04150391},

/* 120 */  { 2.13232422,  0.49121094, -0.61132812, -0.71582031, -0.67529297},
/* 121 */  { 1.88085938,  0.77099609, -0.03759766,  1.00781250,  0.41894531},
/* 122 */  { 2.49462891,  1.42529297, -0.09863281,  0.17529297, -0.24853516},
/* 123 */  { 1.78222656,  1.56542969,  1.12451172,  0.82666016,  0.63281250},
/* 124 */  { 1.41845703, -1.90771484,  0.11181641, -0.58398438, -1.13867188},
/* 125 */  { 2.91845703, -1.75048828,  0.39306641,  1.86767578, -1.53222656},
/* 126 */  { 1.82910156, -0.29589844,  0.02587891, -0.13134766, -1.61181641},
/* 127 */  { 0.29589844,  0.98535156, -0.64257812,  1.98437500,  0.19433594},
       };


real cb_gain[] = {
     0.515625,  .9234375,  1.579101563,  2.763427734,
    -0.515625, -.9234375, -1.579101563, -2.763427734
};

/* Double Gains: */
real cb_gain2[] = {
     1.031250,  1.846875,  3.158203,  5.526855,
    -1.031250, -1.846875, -3.158203, -5.526855};

/* Midpoints: */
real cb_gain_mid[] = {
     0.708984375,  1.240722656,  2.171264649, 0, 
    -0.708984375, -1.240722656, -2.171264649, 0};

/* Squared Gains: */
real cb_gain_sq[] = {
    0.265869, 0.8527368, 2.493562, 7.636533,
    0.265869, 0.8527368, 2.493562, 7.636533};


real WIN_MEM hw_gain[] = {
 0.583953857, 0.605346680, 0.627502441, 0.650482178, 0.674316406,
 0.699005127, 0.724578857, 0.751129150, 0.778625488, 0.807128906,
 0.836669922, 0.867309570, 0.899078369, 0.932006836, 0.961486816,
 0.982757568, 0.995635986, 1.000000000, 0.995819092, 0.983154297,
 0.962066650, 0.932769775, 0.895507812, 0.850585938, 0.798400879,
 0.739379883, 0.674072266, 0.602996826, 0.526763916, 0.446014404,
 0.361480713, 0.273834229, 0.183868408, 0.092315674
 };

real WIN_MEM hw_percw[] = {
 0.581085205, 0.591217041, 0.601562500, 0.612091064, 0.622772217,
 0.633666992, 0.644744873, 0.656005859, 0.667480469, 0.679138184,
 0.691009521, 0.703094482, 0.715393066, 0.727874756, 0.740600586,
 0.753570557, 0.766723633, 0.780120850, 0.793762207, 0.807647705,
 0.821746826, 0.836120605, 0.850738525, 0.865600586, 0.880737305,
 0.896148682, 0.911804199, 0.927734375, 0.943939209, 0.960449219,
 0.975372314, 0.986816406, 0.994720459, 0.999084473, 0.999847412,
 0.997070312, 0.990722656, 0.980865479, 0.967468262, 0.950622559,
 0.930389404, 0.906829834, 0.880035400, 0.850097656, 0.817108154,
 0.781219482, 0.742523193, 0.701171875, 0.657348633, 0.611145020,
 0.562774658, 0.512390137, 0.460174561, 0.406311035, 0.351013184,
 0.294433594, 0.236816406, 0.178375244, 0.119262695, 0.059722900
 };

real WIN_MEM hw_synth[] = {
 0.602020264, 0.606384277, 0.610748291, 0.615142822, 0.619598389,
 0.624084473, 0.628570557, 0.633117676, 0.637695312, 0.642272949,
 0.646911621, 0.651580811, 0.656280518, 0.661041260, 0.665802002,
 0.670593262, 0.675445557, 0.680328369, 0.685241699, 0.690185547,
 0.695159912, 0.700164795, 0.705230713, 0.710327148, 0.715454102,
 0.720611572, 0.725830078, 0.731048584, 0.736328125, 0.741638184,
 0.747009277, 0.752380371, 0.757812500, 0.763305664, 0.768798828,
 0.774353027, 0.779937744, 0.785583496, 0.791229248, 0.796936035,
 0.802703857, 0.808502197, 0.814331055, 0.820220947, 0.826141357,
 0.832092285, 0.838104248, 0.844146729, 0.850250244, 0.856384277,
 0.862548828, 0.868774414, 0.875061035, 0.881378174, 0.887725830,
 0.894134521, 0.900604248, 0.907104492, 0.913635254, 0.920227051,
 0.926879883, 0.933563232, 0.940307617, 0.947082520, 0.953918457,
 0.960815430, 0.967742920, 0.974731445, 0.981781006, 0.988861084,
 0.994842529, 0.998565674, 0.999969482, 0.999114990, 0.996002197,
 0.990600586, 0.982910156, 0.973022461, 0.960876465, 0.946533203,
 0.930053711, 0.911437988, 0.890747070, 0.868041992, 0.843322754,
 0.816680908, 0.788208008, 0.757904053, 0.725891113, 0.692199707,
 0.656921387, 0.620178223, 0.582000732, 0.542480469, 0.501739502,
 0.459838867, 0.416900635, 0.373016357, 0.328277588, 0.282775879,
 0.236663818, 0.189971924, 0.142852783, 0.095428467, 0.047760010
 };
