#include "proto.h"
#include "phonemes.h"
#include "features.h"
#include "gen.h"

void
gen_sonorant(phone,segdur,prev_feat,next_feat,next_phone)
int phone;
int segdur;
unsigned long prev_feat;
unsigned long next_feat;
int next_phone;
{unsigned long features  = Features[phone];
 int j, off, interp2 = 0;
 int interp = 0, time_count, time_const;
 float f1_temp, f2_temp, f3_temp, bw1_temp, bw2_temp, bw3_temp;
 float av_temp;

 int length = segdur / 10;

 if (next_feat != 0)
  {
   if (next_feat & VOWEL)
    {
     /* sonorants move to a following voiced segment */
     translate_phone(next_phone, &off);
     av[1] = (float) VOWEL_AV;
     f1[1] = (float) Vowels[off][0][F1];
     f2[1] = (float) Vowels[off][0][F2];
     f3[1] = (float) Vowels[off][0][F3];
     bw1[1] = (float) Vowels[off][0][BW1];
     bw2[1] = (float) Vowels[off][0][BW2];
     bw3[1] = (float) Vowels[off][0][BW3];
     interp = 1;
     interp2 = 1;
    }
   else if (next_feat & NASAL)
    {
     translate_phone(next_phone, &off);
     av[1] = (float) Nasals[off][9];
     f1[1] = (float) Nasals[off][0];
     f2[1] = (float) Nasals[off][1];
     f3[1] = (float) Nasals[off][2];
     bw1[1] = (float) Nasals[off][3];
     bw2[1] = (float) Nasals[off][4];
     bw3[1] = (float) Nasals[off][5];
     interp = 1;
    }
  }

 f1_temp = f1[0];
 f2_temp = f2[0];
 f3_temp = f3[0];
 bw1_temp = bw1[0];
 bw2_temp = bw2[0];
 bw3_temp = bw3[0];
 av_temp = av[0];

 time_const = segdur;
 time_count = 0;
 for (j = 0; j < segdur; j += 10)
  {
   Frames[total_frame_count].f0 = (int) f0[0];
   Frames[total_frame_count].f1 = (int) f1_temp;
   Frames[total_frame_count].f2 = (int) f2_temp;
   Frames[total_frame_count].f3 = (int) f3_temp;
   Frames[total_frame_count].bw1 = (int) bw1_temp;
   Frames[total_frame_count].bw2 = (int) bw2_temp;
   Frames[total_frame_count].bw3 = (int) bw3_temp;
   Frames[total_frame_count].fnz = (int) fnz;
   Frames[total_frame_count].fnp = (int) fnp;
   Frames[total_frame_count].av = (int) av_temp;
   Frames[total_frame_count].tlt = 0;
   Frames[total_frame_count].asp = (int) asp;
   Frames[total_frame_count].af = (int) af;
   Frames[total_frame_count].a1 = (int) a1;
   Frames[total_frame_count].a2 = (int) a2;
   Frames[total_frame_count].a3 = (int) a3;
   Frames[total_frame_count].a4 = (int) a4;
   Frames[total_frame_count].a5 = (int) a5;
   Frames[total_frame_count].a6 = (int) a6;
   Frames[total_frame_count].ab = (int) ab;

   if (f0_change != -1000)
    f0[0] += f0_change;
   else
    f0[0] -= 20;

   if (interp && interp2)
    {
     if (next_feat & NASAL)
      {
       f1_temp = gen_curve(f1[0], f1[1], 10, time_count);
       f2_temp = gen_curve(f2[0], f2[1], 10, time_count);
       f3_temp = gen_curve(f3[0], f3[1], 10, time_count);
       bw1_temp = gen_curve(bw1[0], bw1[1], 10, time_count);
       bw2_temp = gen_curve(bw2[0], bw2[1], 10, time_count);
       bw3_temp = gen_curve(bw3[0], bw3[1], 10, time_count);
       av_temp = gen_curve(av[0], av[1], 10, time_count);
      }
     else
      {
       f1_temp = gen_curve(f1[0], f1[1], time_const / 4, time_count);
       f2_temp = gen_curve(f2[0], f2[1], time_const / 4, time_count);
       f3_temp = gen_curve(f3[0], f3[1], time_const / 4, time_count);
       bw1_temp = gen_curve(bw1[0], bw1[1], time_const / 4, time_count);
       bw2_temp = gen_curve(bw2[0], bw2[1], time_const / 4, time_count);
       bw3_temp = gen_curve(bw3[0], bw3[1], time_const / 4, time_count);
       av_temp = gen_curve(av[0], av[1], time_const / 4, time_count);
      }
    }

   /* We get called for NASAL features */
   if ((j > 60) && (features & NASAL))
    interp2 = 1;
   else if ((j > 10) && !(features & NASAL))
    interp2 = 1;

   if (next_feat != -1)
    if ((next_feat & NASAL) && (j == (segdur - 50)))
     {
      f1[0] = f1_temp;
      f2[0] = f2_temp;
      f3[0] = f3_temp;
      bw1[0] = bw1_temp;
      bw2[0] = bw2_temp;
      bw3[0] = bw3_temp;
      av[0] = av_temp;
      interp2 = 1;
      time_count = -10;
     }

   time_count += 10;
   total_frame_count++;
  }
 /* retain block copy till we make LastTarget a pointer */
 LastTarget = Frames[total_frame_count - 1];
}
