#include "proto.h"
#include "phonemes.h"
#include "features.h"
#include "gen.h"
#include <math.h>
#include <stdio.h>

void
segdur(ph_list, duration, count)
int *ph_list;
int *duration;
int count;
{
 int i;
 unsigned long prev_feature = 0;

 /* Start all at 100% */
 for (i = 0; i < count; i++)
  duration[i] = 100;

 for (i = 0; i < count; i++)
  {int phone = ph_list[i];
   if (phone >= VOWELS_START && phone < ALL_END)
    {
     unsigned long features = Features[phone];
     int next_phone = ((i+1) < count) ? ph_list[i+1] : lWORD_BREAK;
     unsigned long next_feature = Features[next_phone];
     if ((features & SYLLA) && (next_phone != lWORD_BREAK))
      {
       /* rule 4 */
       duration[i] = (duration[i] * 85) / 100;
      }
#if 0
     /* lSYLLABLE is not appropriate and num_syllables
        was initialized to 1 and never changed ...
     */
     if ((features & lSYLLABLE) && (num_syllables > 1))
      {
       /* rule 5 */
       duration[i] = (duration[i] * 80) / 100;
      }
#endif
     if (!(features & VOWEL) && i != 0)
      {
       /* rule 6 */
       duration[i] = (duration[i] * 85) / 100;
      }

     if (features & VOWEL)
      {
       /* rule 9 */
       if ((next_feature & FRICA) && (next_feature & VOICE))
        {
         duration[i] = (duration[i] * 160) / 100;
        }
       if ((next_feature & PLOSI) && (next_feature & VOICE))
        {
         duration[i] = (duration[i] * 120) / 100;
        }
       if (next_feature & NASAL)
        {
         duration[i] = (duration[i] * 85) / 100;
        }
       if (next_feature & PLOSI)
        {
         duration[i] = (duration[i] * 70) / 100;
        }
      }
     /* rule 10 */
     if ((features & VOWEL) && (next_feature & VOWEL))
      {
       duration[i] = (duration[i] * 120) / 100;
      }

     if ((features & VOWEL) && (prev_feature & VOWEL))
      {
       duration[i] = (duration[i] * 70) / 100;
      }

     if (!(features & VOWEL) && !(next_feature & VOWEL) && !(prev_feature & VOWEL))
      {
       duration[i] = (duration[i] * 50) / 100;
      }
     else if (!(features & VOWEL) && !(prev_feature & VOWEL))
      {
       duration[i] = (duration[i] * 70) / 100;
      }
     else if (!(features & VOWEL) && !(next_feature & VOWEL))
      {
       duration[i] = (duration[i] * 70) / 100;
      }
     prev_feature = features;
    }
   else if (phone == lSYLLABLE)
    {
     duration[i] = 0;
     if (i > 0)
      {
       duration[i - 1] += 20;
      }
    }
   else if ((phone == lWORD_BREAK) && prev_feature)
    {
     duration[i]  = WORD_BREAK_TIME;
     prev_feature = 0;
    }
   else
    {
     /* All other lexical cases are zero length */
     duration[i]  = 0;
     break;
    }
  }

 for (i = 0; i < count; i++)
  {int phone = ph_list[i];
   if (phone >= VOWELS_START)
    {
     int mindur = MinDur[phone];
     int inhdur = InhDur[phone];
     /* was just duration >= 0 */
     if (duration[i] >= 0)
      duration[i] = ((inhdur - mindur) * duration[i]) / 100 + mindur;
     else
      duration[i] = 0;
    }
   printf("Phone %2d %-2s len: %3d\n", i, Phoneme_name[phone], duration[i]);
  }
}


int
gen_curve(Ai, Af, time_const, t)
float Ai;
float Af;
int time_const;
int t;

{
 double temp1 = exp(-1 * (double) t / (double) time_const);
/*
   This is a strange sort of "curve", would
   expect exponential decay, so exp(-t/tc) is okay,
   And assume Ai(nitial) and Af(inal) so that
   result = f(t)*(Af-Ai) * Af makes sense
   The dodgy bit is the (1 + t/tc)

   Commenting out the (1 + t/tc) stopped consecutive "mm" phonemes
   going to +60dB!

*/

 temp1 *= (Ai - Af) /* * (1.0 + ((double) t / (double) time_const)) */;

 return (int) (temp1 + Af);
}


