/*****************************************************************/
/*****************************************************************/
/***                                                           ***/
/***                                                           ***/
/***    Play out a 20kHz file on the SPARC                     ***/
/***                                                           ***/
/***                                                           ***/
/***                H.F. Silverman 1/4/91                      ***/
/***    Modified:   H.F. Silverman 1/16/91 for amax parameter  ***/
/***    Modified:   A. Smith 2/14/91 for 8kHz for klatt synth  ***/
/***                                                           ***/
/*** Called: hplay(n,volume,amax,a)                            ***/
/***                                                           ***/
/***   int       n      -- No. of 8kHz pts.                    ***/
/***   int    device    -- 0 -> speaker, 1 -> Jack             ***/
/***                                                           ***/
/***                                                           ***/
/*****************************************************************/
/*****************************************************************/

#include <stdio.h>
#include <math.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/signal.h>

#include <stropts.h>
#include <sys/ioctl.h>

#include "multimedia/libaudio.h"
#include "multimedia/audio_device.h"
#include "multimedia/ulaw2linear.h"
#include "proto.h"
#include "hplay.h"

/*TODO
  Need way of adjusting volume & port from command line (indirectly!)
  Seems to be a "click" at the end of a phrase
  This module should accept linear samples and handle
  all device dependance
*/

#define Error           (void) fprintf

/* Audio Parameters */

int Verbose = FALSE;             /* verbose messages */
int Immediate = FALSE;           /* don't hang waiting for device */
char *Audio_dev = "/dev/audio";

int Audio_fd = -1;               /* file descriptor for audio device */
char *prog = "hplay";
Audio_hdr Dev_hdr;               /* audio header for device */
char *Ifile;                     /* current filename */
Audio_hdr File_hdr;              /* audio header for file */

void
hplay(n,device,plabuf)
int n;
int device;
unsigned char *plabuf;
{
 int err;
 unsigned int myport;
 double vol;

/* Try it quickly, first */

 Audio_fd = open(Audio_dev, O_WRONLY | O_NDELAY);
 if ((Audio_fd < 0) && (errno == EBUSY))
  {
   if (Immediate)
    {
     Error(stderr, "%s: %s is busy\n", prog, Audio_dev);
     exit(1);
    }
   if (Verbose)
    {
     Error(stderr, "%s: waiting for %s...", prog, Audio_dev);
     (void) fflush(stderr);
    }

   /* Now hang until it's open */

   Audio_fd = open(Audio_dev, O_WRONLY);
   if (Verbose)
    Error(stderr, "%s\n", (Audio_fd < 0) ? "" : "open");
  }
 if (Audio_fd < 0)
  {
   Error(stderr, "%s: error opening ", prog);
   perror(Audio_dev);
   exit(1);
  }

/* Get the device output encoding configuration */

 if (audio_get_play_config(Audio_fd, &Dev_hdr) != AUDIO_SUCCESS)
  {
   Error(stderr, "%s: %s is not an audio device\n",
         prog, Audio_dev);
   exit(1);
  }

 vol = (double) 0.55;
 err = audio_set_play_gain(Audio_fd, &vol);
 if (err != AUDIO_SUCCESS)
  {
   Error(stderr,
         "%s: could not set output volume for %s\n",
         prog, Audio_dev);
   exit(1);
  }

/* Set the output port */

 if (device == 0)
  myport = AUDIO_SPEAKER;
 if (device == 1)
  myport = AUDIO_HEADPHONE;
 err = audio_set_play_port(Audio_fd, &myport);
 if (err != AUDIO_SUCCESS)
  {
   Error(stderr, "Could not set port for \n");
   exit(1);
  }

 err = write(Audio_fd, (char *) plabuf, n);
 if (err != n && n > 0)
  {
   Error(stderr, "%s: output error: ", prog);
   perror("");
  }

/* Close audio system  */

 (void) audio_drain(Audio_fd, FALSE);
 (void) close(Audio_fd);
}
