#define MAX_FRAMES 1000
#define WORD_BREAK_TIME 100

typedef struct genpar
 {
  int f0;         /*  0 */   /* Voicing fund freq in Hz                */
  int f1;         /*  1 */   /* First formant freq in Hz,  200 to 1300 */
  int f2;         /*  2 */   /* First formant bw in Hz,     40 to 1000 */
  int f3;         /*  3 */   /* Second formant freq in Hz, 550 to 3000 */
  int bw1;        /*  4 */   /* Second formant bw in Hz,    40 to 1000 */
  int bw2;        /*  5 */   /* Third formant freq in Hz, 1200 to 4999 */
  int bw3;        /*  6 */   /* Third formant bw in Hz,     40 to 1000 */
  int fnz;        /*  7 */   /* Nasal zero freq in Hz,     248 to  528 */
  int fnp;        /*  8 */   /* Nasal pole freq in Hz,     248 to  528 */
  int av;         /*  9 */   /* Amp of voicing in dB,         0 to 70 */
  int tlt;        /* 10 */   /* Voicing spectral tilt in dB,  0 to 24 */
  int asp;        /* 11 */   /* Amp of aspiration in dB,      0 to 70 */
  int af;         /* 12 */   /* Amp of frication in dB,       0 to 80 */
  int a1;         /* 13 */   /* Amp of par 1st formant in dB, 0 to 80 */
  int a2;         /* 14 */   /* Amp of F2 frication in dB,    0 to 80 */
  int a3;         /* 15 */   /* Amp of F3 frication in dB,    0 to 80 */
  int a4;         /* 16 */   /* Amp of F4 frication in dB,    0 to 80 */
  int a5;         /* 17 */   /* Amp of F5 frication in dB,    0 to 80 */
  int a6;         /* 18 */   /* Amp of F6 (same as r6pa),     0 to 80 */
  int ab;         /* 19 */   /* Amp of bypass fric. in dB,    0 to 80 */
 } genpar_t, *genpar_ptr;

extern genpar_t LastTarget;
extern genpar_t Frames[MAX_FRAMES];
extern int total_frame_count;

extern float length;
extern float f0[2], f1[2], f2[2], f3[2], bw1[2], bw2[2], bw3[2], av[2];
extern float s_f0, s_f1, s_f2, s_f3, s_bw1, s_bw2, s_bw3, s_av;
extern float fnz;
extern float fnp;
extern float asp, af, ab, a1, a2, a3, a4, a5, a6;
extern int f0_change;

#define UNKNOWN_PHONEME  (ALL_END+1)
#define QUIT             (ALL_END+2)
#define SAVE_MOST_RECENT (ALL_END+3)
#define PLAY_AGAIN       (ALL_END+4)


extern int read_phonemes   PROTO((int *ph_list));
extern void gen_plosive    PROTO((int phone, int segdur, unsigned long prev_feat, unsigned long next_feat, int next_phone));
extern void gen_fricative  PROTO((int phone, int segdur, unsigned long prev_feat, unsigned long next_feat, int next_phone));
extern void gen_vowel      PROTO((int phone, int segdur, unsigned long prev_feat, unsigned long next_feat, int next_phone));
extern void gen_sonorant   PROTO((int phone, int segdur, unsigned long prev_feat, unsigned long next_feat, int next_phone));
extern int translate_phone PROTO((int ph, int *offset));
extern int gen_curve       PROTO((float Ai, float Af, int time_const, int t));
extern void segdur         PROTO((int *seg_list, int *return_list, int count));

