//   file : generate_seq.cc
//  author: Richard Myers
// version: a0.01 [May 21, 1994]
//
// This program generates random sequences using the probabilities defined
// in a markov model file.


#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "hmm.h"

main(int argc, char* argv[])
{
  // check args
  if (argc < 3) {
    cerr << "ERROR: Too few arguments.\n\n" <<
    "Usage: " << argv[0] << " <hmm_model> <num_seq> <len_seq>\n\n";
    exit (-1);
  }
  
  // get command line parms
  char* hmm_def_file = argv[1];
  int num_seq = atoi(argv[2]);
  int len_seq = atoi(argv[3]);

  // create the hmm from model file
  hmm *new_hmm = new hmm(hmm_def_file);
  
  // dump the resulting model to a file
  char newfilename[100];
  sprintf(newfilename,"%s.seq",hmm_def_file);
  new_hmm->dump_seq(newfilename,num_seq,len_seq);
}

