/*
  title:    swappers.c
  purpose:  Byte swapping routines for various data types.

  author:   Gareth Lee.
  date:     26-4094
  modified:

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  changes:
*/

void swap2(unsigned char* p)
{
  static char c0; static char c1;
  c0 = p[0];      c1 = p[1];
  p[0] = c1;      p[1] = c0;
}

void swap4(unsigned char* p)
{
  static char c0; static char c1;
  static char c2; static char c3;
  c0 = p[0];      c1 = p[1];
  c2 = p[2];      c3 = p[3];
  p[0] = c3;      p[1] = c2;
  p[2] = c1;      p[3] = c0;
}
 
void swap8(unsigned char* p)
{
  static char c0; static char c1;
  static char c2; static char c3;
  static char c4; static char c5;
  static char c6; static char c7;
  c0 = p[0];      c1 = p[1];
  c2 = p[2];      c3 = p[3];
  c4 = p[4];      c5 = p[5];
  c6 = p[6];      c7 = p[7]; 
  p[0] = c7;      p[1] = c6;
  p[2] = c5;      p[3] = c4;
  p[4] = c3;      p[5] = c2;
  p[6] = c1;      p[7] = c0;
}
 
/* end of swappers.h */
