/*
  title:     entropy_seg.h
  purpose:   Locate observations within sequence associated with high
             predictive entropy.

  author:    Gareth Lee.
  date:      04-07-93
  modified:  05-07-93

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  changes:
*/

#define free_vector(v) free(v)

/* prototypes */
void linear_predict(int frames, int dims, real** obs, real** error);
void mean_covar(int frames, int dims, real** error, real* mean, real** covar);
void invert(int dims, real** m, real** I);
real mahalanobis(int dims, real* vector, real* mean, real** icovar);
real** make_matrix(int r, int c);
void free_matrix(int r, real** p);
real* make_vector(int r);
int find_segmentation(int frames, int dims, real** obs, int* order,
                      int direction, int ratio);
int find_diff_segmentation(int frames, int dims, real** obs, int* order,
                           int direction, int ratio);
int find_diff2_segmentation(int frames, int dims, real** obs, int* order,
                            int direction, int ratio);

/* end of entropy_seg.h */
