/*
  note: modified by Gareth Lee.  03-11-93
*/

static char SccsID[] = "@(#)windows.c	1.1   3/3/89";
/*
  Copyright (C) 1994 Edmund Lai and Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	Speech Signal Processing Software Library
 *
 *	=== WINDOWS.C ===
 *
 *	Consists of the following functions:
 *	(1)  Hamming  --  generates a Hamming window sequence.
 *	(2)  Hanning  --  generates a Hanning window sequence.
 *	(3)  window   --  performs windowing function.
 *	(3)  Square   --  generates a Square window sequence.
 *
 *	Edmund Lai
 *	Department of Electrical & Electronic Engineering
 *	The University of Western Australia
 *
 *-----------------------------------------------------------------
 *
 *	void Hamming (int,double *);
 *	void Hanning (int,double *);
 *
 *	n	: length of window sequence
 *	w	: window sequence
 *
 *
 *	void window (int,double *,double *);
 *
 *	n	: length of sample sequence
 *	w	: window sequence
 *	x	: sample sequence
 *
 *----------------------------------------------------------------*/

#include <math.h>
 
#define	PI	M_PI


/*===== Hamming =====*/
void Hamming (n,w)
int	n;
double  *w;
{
	int	i;
	double	d;
	
	if (n <= 0)  return;
	d = 2.0 * PI / n;
	for (i = 0; i < n; i++, w++)
		*w = (0.54 - 0.46 * cos(d*(i+1)));
}


/*===== Hanning =====*/
void Hanning (n,w)
int	n;
double	*w;
{
	int	i;
	double	d;

	if (n <= 0)  return;
	d = 2.0 * PI / n;
	for (i = 0; i < n; i++, w++)
		*w = (0.50 - 0.50 * cos(d*(i+1)));
}

/*===== Square =====*/
void Square (n,w)
int	n;
double	*w;
{
	int	i;

	if (n <= 0)  return;
	for (i = 0; i < n; i++, w++)
		*w = 1.0;
}


/*===== window =====*/
void window (n,w,x)
int	n;
double	*w;
double	*x;
{
	int	i;

	for (i = 0; i < n; i++,x++,w++)
		*x *= *w;
}
