/* Prototypes for functions in projectors.c */

#define MAX_COLORS    (20)

#define X_MARGIN_3D   (80)
#define Y_MARGIN_3D   (20)

/*
  DEPTH_SCALING controls the degree of depth separation introduced between the
    two eye views when drawing in three dimensional modes.
*/
#define DEPTH_SCALING (40.0)

/* Color allocating functions */

void SetupColorEntries(void);
int AllocateColorEntry(void);
void FreeColorEntry(int color);

/* Drawing Functions */
void draw_3d_graphics(unsigned int, unsigned int, int);
void draw_3d_sweep(unsigned int, unsigned int, int label, unsigned int);
void draw_2d_graphics(unsigned int, unsigned int, int);
void draw_2d_sweep(unsigned int, unsigned int, int, unsigned int);
void draw_spectrogram(unsigned int, unsigned int, int);
