/*
  title:    xv_interface.c
  purpose:  xview widget bindings for sp_proj3.c program.
            Should replace sp_window.c which is an Xlib bound version.

  author:   Gareth Lee and Hugh Sanderson.
  date:     15-07-93
  modified: 11-08-93

  changes:
  11-08-93: CreateDrawingWindow() mod'd to ensure that the window background is
    always set to white.  This ensures that the trajectories drawn are always
    visible no matter what default screen background colour the user has set.
*/

/*****************************************************************************/

/* File numbers for the standard i/o channels */
#define STDOUT_FD 0
#define STDIN_FD  1
#define STDERR_FD 2

/* Maximum number of samples that can be examined */
/* #define DIMENSION   (12) */

#define DEFAULT_FONT_NAME "*helvetica-medium-r-normal--14*"

/* Colour definitions */
#define BLACK         0
#define BLUE          1
#define RED           2
#define GREEN         3
#define MAROON        4
#define DARKSLATEGREY 5
#define KHAKI         6
#define MAGENTA       7
#define NAVYBLUE      8   
#define GOLDENROD     9
#define PINK          10
#define PURPLE        11  
#define THISTLE       12  
#define SIENNA        13  
#define AQUAMARINE    14
#define ORCHID        15  
#define VIOLET        16  
#define TOMATO        17
#define OLIVEDRAB     18
#define ORANGE        19  

/* Graded set of colours to implement spectrum from cool to hot */
extern const char* SpectrumColors[];

/*****************************************************************************/

/* external declarations for Widget handles for objects in xv_interface.c */
extern Xv_opaque MainFrame;
extern Xv_opaque MainPanel;
extern Xv_opaque SampleFrame;
extern Xv_opaque SamplePanel;
extern Xv_opaque SpecifyFrame;
extern Xv_opaque SpecifyPanel;
extern Xv_opaque RotationSelector1;
extern Xv_opaque RotationSelector2;
extern Xv_opaque DisplayFrame;
extern Xv_opaque DisplayPanel;
extern Xv_opaque DisplayCanvas;
extern Xv_opaque DisplaySlider;
extern Xv_opaque DisplayRandomizeButton;
extern Xv_opaque DisplayStoreButton;
extern Xv_opaque DisplayRecallButton;
extern Xv_opaque DisplayCheckBox;
extern Xv_opaque DisplayDecrButton;
extern Xv_opaque DisplayIncrButton;
extern Xv_opaque ControlAutoScaleButton;
extern Xv_opaque UpDownSlider;
extern Xv_opaque LeftRightSlider;
extern Xv_opaque EnlargeShrinkSlider;
extern Xv_opaque ControlAnimateButton;
extern Xv_opaque AngleSlider;
extern Xv_opaque ControlSweepButton;
extern Xv_opaque SweepRateSlider;
extern Xv_opaque IterationSlider;
extern Xv_opaque ControlSpecifyButton;
extern Xv_opaque SpecifySelector1;
extern Xv_opaque SpecifyRandEq1Choice;
extern Xv_opaque SpecifySelector2;
extern Xv_opaque SpecifyRandEq2Choice;
extern Xv_opaque SpecifySelector3;
extern Xv_opaque SpecifyRandEq3Choice;
extern Xv_opaque SpecifyProjectButton;
extern Xv_opaque ControlSamplesButton;
extern Xv_opaque SampleListnameText;
extern Xv_opaque SampleDimensionText;
extern Xv_opaque SampleNumSampsText;
extern Xv_opaque SampleFileList;
extern Xv_opaque SampleFormatList;
extern Xv_opaque SampleFrontendList;
extern Xv_opaque SampleUpdateButton;
extern Xv_opaque SampleParamsButton;
extern Xv_opaque SampleCheckBox;
extern Xv_opaque ParamsFrame;
extern Xv_opaque ParamsPanel;
extern Xv_opaque ParamsFormatNameText;
extern Xv_opaque ParamsFormatFilterText;
extern Xv_opaque ParamsFrontendNameText;
extern Xv_opaque ParamsFrontendFilterText;
extern Xv_opaque ParamsFormatList;
extern Xv_opaque ParamsFrontendList;
extern Xv_opaque ParamsFormatValueText;
extern Xv_opaque ParamsFrontendValueText;
extern Xv_opaque ControlHighlightButton;
extern Xv_opaque HighlightFrame;
extern Xv_opaque HighlightPanel;
extern Xv_opaque HighlightSlider;
extern Xv_opaque HighlightSelector;
extern Xv_opaque HighlightCheckBox;

extern Server_image ciips_image;
extern Icon         ciips_icon;
extern Xv_Cursor BasicCursor;
extern Xv_Cursor BusyCursor;

/*****************************************************************************/

/* function templates */
void SetCursors(Xv_Cursor cursor);
void ChangeBandWidgets(void);
void PrepareConverterLists(void);
void SampleFillScrollList(Xv_opaque list, OptionRecord *options);
void SampleEmptyScrollList(Xv_opaque list);

/*****************************************************************************/

/* end of interface.h */

