/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void UTwarn (const char Warnmsg[], ...)

Purpose:
  Print a warning message

Description:
  This routine prints a warning message on stderr (standard error).

Parameters:
  ->  const char []
  Warnmsg -	Character string to be printed.  This string can contain
		optional formatting codes.  The arguments corresponding to the
		formatting codes appear at the end of the argument list.  The
		input string should not normally have a terminating newline
		character, since this routine supplies a newline.
  ->  <type based on format code>
  args -	Arguments corresponding to the formatting codes.  The format
		string and the variable number of arguments is passed on to
		the system routine vprintf.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.10 $  $Date: 1994/02/15 14:49:51 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTwarn.c 1.10 1994/02/15 AFsp-V1R2 $";

#include <stdio.h>
#include <libtsp.h>

#ifdef __STDC__

/* ANSI version using stdargs.h */
#include <stdarg.h>

void
UTwarn (const char Warnmsg[], ...)

{
  va_list ap;

  va_start (ap, Warnmsg);

#else /* not __STDC__ */

/* K&R C version using varargs.h */
#include <varargs.h>

void
UTwarn (va_alist)

     va_dcl

{
  va_list ap;
  char *Warnmsg;

  va_start (ap);
  Warnmsg = va_arg (ap, char *);

#endif /* __STDC__ */

/* Print the warning message */
  vfprintf (stderr, Warnmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);
}

