/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  char *UTuserName (void)

Purpose:
  Get the user name

Description:
  This routine returns the user name and host name.  The user name is
  determined by using the user id to find the name in the password database
  with this uid.  The returned string is of the form user@host.

Parameters:
  <- char []
  UTuserName -	Pointer to a character string containing the user name.  This
		string is null terminated.  This is a pointer to an internal
		static storage area; each call to this routine overlays this
		storage.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.15 $  $Date: 1994/02/23 22:50:50 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTuserName.c 1.15 1994/02/23 AFsp-V1R2 $";

#include <unistd.h>		/* getuid definitions */
#include <pwd.h>		/* password entry definitions */
#include <libtsp.h>

/*
   Maximum string length is max_length_user_name + 1 (for '@') + MAXHOSTNAMELEN
   max_length_user_name is 8 on many Unix systems
   */
#include <sys/param.h>		/* MAXHOSTNAMELEN on many systems */
#ifndef MAXHOSTNAMELEN
#	include <netdb.h>	/* For Solaris */
#endif

#define MAXLEN	MAXHOSTNAMELEN+16
static char User[MAXLEN+1];

char *
UTuserName ()

{
  struct passwd *pwd;
  char hostname[MAXHOSTNAMELEN+1];

/*
   Find the password entry associated with the uid.  Using environment
   variables such as USER or LOGNAME does not work consistently since not all
   shells set these environment variables for the user.
*/
  pwd = getpwuid (getuid ());
  if (pwd != NULL) {
    STcopyMax (pwd->pw_name, User, MAXLEN);
  }
  else {
    UTwarn ("UTuserName: Error return from getpwuid");
    User[0] = '\0';
  }

/* Append the host name */
  STcatMax ("@", User, MAXLEN);
  gethostname (hostname, MAXHOSTNAMELEN);
  hostname[MAXHOSTNAMELEN+1] = '\0';	/* in case host name is too long */
  STcatMax (hostname, User, MAXLEN);

  return User;
}
