/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void UTsysErrHalt (const char Errmsg[], ...)

Purpose:
  Print error messages, stop with error status set

Description:
  This routine prints the system error message corresponding to the last
  system error encountered.  It then prints a user defined error message.
  Messages are written to stderr (standard error).  Execution is terminated
  and the exit status is set to EXIT_FAILURE.

Parameters:
  ->  const char []
  Errmsg -	Character string to be printed.  This string can contain
		optional formatting codes.  The arguments corresponding to the
		formatting codes appear at the end of the argument list.  The
		input string should not normally have a terminating newline
		character, since this routine supplies a newline.
  ->  <type based on format code>
  args -	Arguments corresponding to the formatting codes.  The format
		string and the variable number of arguments is passed on to
		the system routine vprintf.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.11 $  $Date: 1994/02/15 14:49:28 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTsysErrHalt.c 1.11 1994/02/15 AFsp-V1R2 $";

#include <stdio.h>
#include <stdlib.h>		/* definition of exit */
#include <libtsp.h>

#ifndef EXIT_FAILURE
#	define EXIT_FAILURE	1	/* Normally in stdlib.h */
#endif

#ifdef __STDC__

/* ANSI version using stdarg.h */
#include <stdarg.h>

void
UTsysErrHalt (const char Errmsg[], ...)

{
  va_list ap;
  char *p;

  va_start (ap, Errmsg);

#else /* not __STDC__ */

/* K&R C version using varargs.h */
#include <varargs.h>

void
UTsysErrHalt (va_alist)

     va_dcl

{
  va_list ap;
  char *Errmsg;
  char *p;

  va_start (ap);
  Errmsg = va_arg (ap, char *);

#endif /* __STDC__ */

/* Print the warning message */
  vfprintf (stderr, Errmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);

/* Print the text for the system error message */
  p = UTgetProg ();
  if (*p != '\0')
    perror (p);
  else
    perror ("UTsysErrHalt");

  exit (EXIT_FAILURE);
}
