/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void *UTmalloc (size_t size)

Purpose:
  Allocate a block of memory

Description:
  This routine invokes the system routine malloc to allocate a block of memory.
  If malloc returns an error, an error message is printed and execution is
  terminated.  The block of memory can be freed up using UTfree (or free).

Parameters:
  <-  void *
  UTmalloc -	Pointer to the allocated memory.  This should be cast to the
		appropriate pointer type.
  ->  size_t
  size -	Size of the memory block to be allocated

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.3 $  $Date: 1994/01/19 23:27:24 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTmalloc.c 1.3 1994/01/19 AFsp-V1R2 $";

#include <stdlib.h>		/* malloc */
#include <stddef.h>		/* definition of NULL */
#include <libtsp.h>

void *
UTmalloc (size)

     size_t size;

{
  void *p;

  p = malloc (size);
  if (p == NULL)
    UTerrorHalt ("UTmalloc: Error return from malloc");
  return p;

}
