/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void UTfree (void *ptr)

Purpose:
  Deallocate a block of memory

Description:
  This routine deallocates a block of memory allocated by UTmalloc (or malloc).

Parameters:
  ->  void *
  ptr -		Pointer to the memory to be deallocated

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/11 14:36:44 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTfree.c 1.5 1994/02/11 AFsp-V1R2 $";

#include <errno.h>
#include <stdlib.h>		/* free */
#include <libtsp.h>

void
UTfree (ptr)

     void *ptr;

{
  if (ptr != NULL) {		/* For non-ANSI compliant versions of free() */
    errno = 0;
    free (ptr);
    if (errno != 0)
      UTsysErrHalt ("UTfree: Error detected in free()");
  }
}
