/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void UTerrorHalt (const char Errmsg[], ...)

Purpose:
  Print an error message, stop with error status set

Description:
  This routine prints an error message on stderr (standard error) and then
  terminates execution with exit status set to EXIT_FAILURE.

Parameters:
  ->  const char []
  Errmsg -	Character string to be printed.  This string can contain
		optional formatting codes.  The arguments corresponding to the
		formatting codes appear at the end of the argument list.  The
		input string should not normally have a terminating newline
		character, since this routine supplies a newline.
  ->  <type based on format code>
  args -	Arguments corresponding to the formatting codes.  The format
		string and the variable number of arguments is passed on to
		the system routine vprintf.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.10 $  $Date: 1994/02/15 14:49:07 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTerrorHalt.c 1.10 1994/02/15 AFsp-V1R2 $";

#include <stdio.h>
#include <stdlib.h>		/* definition of exit */
#include <libtsp.h>

#ifndef EXIT_FAILURE
#	define EXIT_FAILURE	1	/* Normally in stdlib.h */
#endif

#ifdef __STDC__

/* ANSI version using stdarg.h */
#include <stdarg.h>

void
UTerrorHalt (const char Errmsg[], ...)

{
  va_list ap;

  va_start (ap, Errmsg);

#else /* not __STDC__ */

/* K&R C version using varargs.h */
#include <varargs.h>

void
UTerrorHalt (va_alist)

     va_dcl

{
  va_list ap;
  char *Errmsg;

  va_start (ap);
  Errmsg = va_arg (ap, char *);

#endif /* __STDC__ */

/* Print the error message */
  vfprintf (stderr, Errmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);

  exit (EXIT_FAILURE);
}
