/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  void STtrimNMax (const char Si[], char So[], int N, int Maxchar)

Purpose:
  Copy at most N characters, trimming trailing white-space

Description:
  This routine copies characters from the input string to the output string.
  The length of the input string is considered to be equal to N less any
  trailing white-space (as defined by isspace).  Characters are copied from
  input string up to the minimum of the length of the input string and Maxchar.
  A null character in the input string also terminates the transfer at that
  point.  If the input string is longer than Maxchar, a string truncated
  warning message is printed.

Parameters:
  ->  const char []
  Si -		Input character string
  <-  char []
  So -		Output character string.  This string is always null
		terminated, with at most Maxchar characters not including the
		terminating null character.  If the input string is longer than
		Maxchar, only the first Maxchar characters are copied and a
		warning message is printed.
  ->  size_t
  N -           Number of characters to be transferred
  ->  size_t
  Maxchar - 	Maximum number of characters (not including the trailing null
		character) to be placed in So.

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.5 $  $Date: 1994/02/11 14:32:46 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STtrimNMax.c 1.5 1994/02/11 AFsp-V1R2 $";

#include <ctype.h>
#include <libtsp.h>
#include <libtsp/STnucleus.h>

#ifndef __STDC__
#define	const
#endif

void
STtrimNMax (Si, So, N, Maxchar)

     const char Si[];
     char So[];
     size_t N;
     size_t Maxchar;

{
  const char *p;
  int i;

  /* Determine the length of the input string */
  p = Si;
  for (i = 0; i < N; ++i, ++p)
    if (*p == '\0')
      break;

  /* Trim trailing white-space */
  for (p = Si+(i-1); i > 0 ; --i, --p)
    if (! isspace (*p))
      break;

  STcopyNMax (Si, So, i, Maxchar);
}
