/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  char *STtrimIws (const char Si[])

Purpose:
  Trim leading white-space

Description:
  This routine returns a pointer to the first character in a string that is not
  white-space (as defined by isspace).  If the input string consists entirely
  of white-space, this routine returns a pointer to the terminating null
  character.

Parameters:
  <-  char *
  STrimIws -	Pointer to the first non-white-space character
  ->  const char []
  Si -		Input character string

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.1 $  $Date: 1994/02/11 14:36:04 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STtrimIws.c 1.1 1994/02/11 AFsp-V1R2 $";

#include <ctype.h>
#include <libtsp/STnucleus.h>

#ifndef __STDC__
#define	const
#endif

char *
STtrimIws (Si)

     const char Si[];

{
  const char *p;

  /* Find the first non-white-space character */
  for (p = Si; *p != '\0'; ++p) {
    if (! isspace (*p))
      break;
  }

  return ((char *) p);
}
