/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Module:
  char *STstrstrNM (const char Si[], const char Ti[], size_t N, size_t M)

Purpose:
  Search for the first occurrence of Ti in Si

Description:
  This routine searches for the first occurrence of string Ti in the input
  string Si.  The string Si is of length N and the string Ti is of length M.
  Null characters in either string are treated as ordinary characters.

Parameters:
  ->  char []
  Si -		Input character string of length N
  ->  char []
  Ti -		Input character string of length M
  ->  size_t
  N -           Number of characters in Si
  ->  size_t
  M -           Number of characters in Ti

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.4 $  $Date: 1994/01/19 23:24:16 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STstrstrNM.c 1.4 1994/01/19 AFsp-V1R2 $";

#include <stddef.h>		/* NULL */
#include <libtsp/STnucleus.h>

#ifndef __STDC__
#define	const
#endif

char *
STstrstrNM (Si, Ti, N, M)

     const char Si[];
     const char Ti[];
     size_t N;
     size_t M;

{
  const char *si;
  const char *ss;
  const char *tt;
  int i;
  int k;
  int NM;

/* Null search string matches the first character */
  if (M == 0)
    return (char *) Si;

/* Outer loop searches for a match to the first character of Ti */
  NM = (int) N - (int) M;
  si = Si;
  for (i = 0; i <= NM; ++i, ++si) {

    if (*si == *Ti) {
      /* Inner loop checks the remaining characters in Ti */
      ss = si;
      tt = Ti;
      for (k = 1; k < M; ++k) {
	if (*++ss != *++tt) 
	  break;
      }
      if (k == M)
	return (char *) si;
    }

  }
  return NULL;
}
